/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.TypeBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;

public class TypeBinder
extends ANodeBinder {
    @Override
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        ISyntaxNode typeNode = node.getChild(0);
        int dimension = 0;
        while (!(typeNode instanceof IdentifierNode)) {
            typeNode = typeNode.getChild(0);
            ++dimension;
        }
        String typeName = ((IdentifierNode)typeNode).getIdentifier();
        try {
            IOpenClass varType = bindingContext.findType("org.openl.this", typeName);
            if (varType == null) {
                String message = String.format("Can't bind node: '%s'. Can't find type: '%s'.", node.getModule().getCode(), typeName);
                BindHelper.processError(message, node, bindingContext, false);
                return new ErrorBoundNode(node);
            }
            if (dimension > 0) {
                varType = varType.getAggregateInfo().getIndexedAggregateType(varType, dimension);
            }
            BindHelper.checkOnDeprecation(node, bindingContext, varType);
            return new TypeBoundNode(node, varType);
        }
        catch (RuntimeException e) {
            BindHelper.processError(e.getMessage(), node, bindingContext, false);
            return new ErrorBoundNode(node);
        }
    }
}

