/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.cast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.types.IOpenClass;

public class ArrayCast
implements IOpenCast {
    private IOpenClass toComponentType;
    private IOpenCast openCast;
    private int dim;

    public ArrayCast(IOpenClass to, IOpenCast openCast, int dim) {
        if (to == null) {
            throw new IllegalArgumentException("to arg can't be null!");
        }
        if (to.isArray()) {
            throw new IllegalArgumentException("to arg can't be array type!");
        }
        this.toComponentType = to;
        this.openCast = openCast;
        this.dim = dim;
    }

    @Override
    public Object convert(Object from) {
        if (from == null) {
            return null;
        }
        Class<?> c = from.getClass();
        Object f = from;
        ArrayList<Integer> dims = new ArrayList<Integer>();
        while (c.isArray()) {
            int length = Array.getLength(f);
            dims.add(length);
            c = c.getComponentType();
            if (length <= 0) continue;
            f = Array.get(f, 0);
        }
        if (this.dim == dims.size()) {
            boolean g;
            int[] dimensions = new int[dims.size()];
            for (int i = 0; i < dims.size(); ++i) {
                dimensions[i] = (Integer)dims.get(i);
            }
            Object convertedArray = Array.newInstance(this.toComponentType.getInstanceClass(), dimensions);
            int[] x = new int[dimensions.length];
            boolean bl = g = dimensions[0] > 0;
            block2: while (g) {
                int j;
                Object p = from;
                Object w = convertedArray;
                for (j = 0; j < dimensions.length - 1 && dimensions[j + 1] > 0; ++j) {
                    p = Array.get(p, x[j]);
                    w = Array.get(w, x[j]);
                }
                Object t = Array.get(p, x[j]);
                if (t != null && t.getClass().isArray() && dimensions[j + 1] == 0) {
                    int[] y = new int[dimensions.length - j - 1];
                    t = Array.newInstance(this.toComponentType.getInstanceClass(), y);
                } else {
                    t = this.openCast.convert(t);
                }
                Array.set(w, x[j], t);
                int n = j = 0;
                x[n] = x[n] + 1;
                while (x[j] >= dimensions[j]) {
                    x[j] = 0;
                    if (j + 1 >= dimensions.length || dimensions[j + 1] == 0) {
                        g = false;
                        continue block2;
                    }
                    int n2 = j + 1;
                    x[n2] = x[n2] + 1;
                    ++j;
                }
            }
            return convertedArray;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.dim; ++i) {
            sb.append("[]");
        }
        throw new ClassCastException(from.getClass().getSimpleName() + " can't be cast to " + this.toComponentType.getInstanceClass().getCanonicalName() + sb.toString());
    }

    @Override
    public int getDistance(IOpenClass from, IOpenClass to) {
        return 1000 + this.openCast.getDistance(from, to);
    }

    @Override
    public boolean isImplicit() {
        return this.openCast.isImplicit();
    }
}

