/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.cast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.impl.cast.AliasToTypeCast;
import org.openl.binding.impl.cast.ArrayCast;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.cast.JavaBoxingCast;
import org.openl.binding.impl.cast.JavaDownCast;
import org.openl.binding.impl.cast.JavaNoCast;
import org.openl.binding.impl.cast.JavaUnboxingCast;
import org.openl.binding.impl.cast.JavaUpCast;
import org.openl.binding.impl.cast.MethodBasedCast;
import org.openl.binding.impl.cast.OneElementArrayCast;
import org.openl.binding.impl.cast.ThrowableVoidCast;
import org.openl.binding.impl.cast.TypeToAliasCast;
import org.openl.binding.impl.cast.TypeToAliasWithJavaBoxingCast;
import org.openl.binding.impl.cast.TypeToAliasWithJavaUnboxingCast;
import org.openl.cache.GenericKey;
import org.openl.ie.constrainer.ConstrainerObject;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;

public class CastFactory
implements ICastFactory {
    public static final int NO_CAST_DISTANCE = 0;
    public static final int ALIAS_TO_TYPE_CAST_DISTANCE = 0;
    public static final int TYPE_TO_ALIAS_CAST_DISTANCE = 1;
    public static final int JAVA_UP_ARRAY_TO_ARRAY_CAST_DISTANCE = 2;
    public static final int JAVA_UP_CAST_DISTANCE = 3;
    public static final int THROWABLE_VOID_CAST_DISTANCE = 4;
    public static final int PRIMITIVE_TO_PRIMITIVE_AUTOCAST_DISTANCE = 5;
    public static final int TYPE_TO_ALIAS_WITH_JAVA_BOXING_CAST_DISTANCE = 6;
    public static final int JAVA_BOXING_CAST_DISTANCE = 7;
    public static final int PRIMITIVE_TO_NONPRIMITIVE_AUTOCAST_DISTANCE = 8;
    public static final int JAVA_BOXING_UP_CAST_DISTANCE = 9;
    public static final int TYPE_TO_ALIAS_WITH_JAVA_UNBOXING_CAST_DISTANCE = 10;
    public static final int JAVA_UNBOXING_CAST_DISTANCE = 11;
    public static final int NONPRIMITIVE_TO_NONPRIMITIVE_AUTOCAST_DISTANCE = 12;
    public static final int ENUM_TO_STRING_CAST_DISTANCE = 13;
    public static final int NONPRIMITIVE_TO_PRIMITIVE_AUTOCAST_DISTANCE = 14;
    public static final int JAVA_DOWN_CAST_DISTANCE = 30;
    public static final int PRIMITIVE_TO_PRIMITIVE_CAST_DISTANCE = 31;
    public static final int NONPRIMITIVE_TO_NONPRIMITIVE_CAST_DISTANCE = 32;
    public static final int NONPRIMITIVE_TO_PRIMITIVE_CAST_DISTANCE = 33;
    public static final int PRIMITIVE_TO_NONPRIMITIVE_CAST_DISTANCE = 34;
    public static final int ARRAY_CAST_DISTANCE = 1000;
    public static final int ONE_ELEMENT_ARRAY_CAST_DISTANCE = 2000;
    public static final String AUTO_CAST_METHOD_NAME = "autocast";
    public static final String CAST_METHOD_NAME = "cast";
    public static final String DISTANCE_METHOD_NAME = "distance";
    private static final JavaNoCast JAVA_NO_CAST = new JavaNoCast();
    private static final JavaUpCast JAVA_UP_CAST = new JavaUpCast(3);
    private static final JavaUpCast JAVA_UP_ARRAY_TO_ARRAY_CAST = new JavaUpCast(2);
    private static final JavaBoxingCast JAVA_BOXING_CAST = new JavaBoxingCast();
    private static final JavaUnboxingCast JAVA_UNBOXING_CAST = new JavaUnboxingCast();
    private static final JavaBoxingCast JAVA_BOXING_UP_CAST = new JavaBoxingCast(9);
    private static final ThrowableVoidCast THROWABLE_VOID_CAST = new ThrowableVoidCast();
    private IMethodFactory methodFactory;
    private ICastFactory globalCastFactory;
    private Map<Object, IOpenCast> castCache = new HashMap<Object, IOpenCast>();
    private ReadWriteLock castCacheLock = new ReentrantReadWriteLock();

    public void setMethodFactory(IMethodFactory factory) {
        this.methodFactory = factory;
    }

    @Override
    public IOpenClass findClosestClass(IOpenClass openClass1, IOpenClass openClass2) {
        Iterable<IOpenMethod> autocastMethods = this.methodFactory.methods(AUTO_CAST_METHOD_NAME);
        return CastFactory.findClosestClass(openClass1, openClass2, this, autocastMethods);
    }

    public static IOpenClass findClosestClass(IOpenClass openClass1, IOpenClass openClass2, ICastFactory casts, Iterable<IOpenMethod> methods) {
        Iterator<IOpenMethod> itr = methods.iterator();
        HashSet<IOpenClass> openClass1Candidates = new HashSet<IOpenClass>();
        CastFactory.addClassToCandidates(openClass1, openClass1Candidates);
        HashSet<IOpenClass> openClass2Candidates = new HashSet<IOpenClass>();
        CastFactory.addClassToCandidates(openClass2, openClass2Candidates);
        while (itr.hasNext()) {
            JavaOpenClass t;
            IOpenMethod method = itr.next();
            if (method.getSignature().getNumberOfParameters() != 2) continue;
            if (method.getSignature().getParameterType(0).equals(openClass1)) {
                CastFactory.addClassToCandidates(method.getSignature().getParameterType(1), openClass1Candidates);
            } else if (method.getSignature().getParameterType(0).getInstanceClass().isPrimitive() && ((Object)(t = JavaOpenClass.getOpenClass(ClassUtils.primitiveToWrapper(method.getSignature().getParameterType(0).getInstanceClass())))).equals(openClass1)) {
                CastFactory.addClassToCandidates(method.getSignature().getParameterType(1), openClass1Candidates);
            }
            if (method.getSignature().getParameterType(0).equals(openClass2)) {
                CastFactory.addClassToCandidates(method.getSignature().getParameterType(1), openClass2Candidates);
                continue;
            }
            if (!method.getSignature().getParameterType(0).getInstanceClass().isPrimitive() || !((Object)(t = JavaOpenClass.getOpenClass(ClassUtils.primitiveToWrapper(method.getSignature().getParameterType(0).getInstanceClass())))).equals(openClass2)) continue;
            CastFactory.addClassToCandidates(method.getSignature().getParameterType(1), openClass2Candidates);
        }
        openClass1Candidates.retainAll(openClass2Candidates);
        IOpenClass ret = null;
        for (IOpenClass openClass : openClass1Candidates) {
            if (ret == null) {
                ret = openClass;
                continue;
            }
            IOpenCast cast = casts.getCast(ret, openClass);
            if (cast != null && cast.isImplicit() || (cast = casts.getCast(openClass, ret)) == null || !cast.isImplicit()) continue;
            ret = openClass;
        }
        if (!(ret == null || openClass1.getInstanceClass() == null || openClass2.getInstanceClass() == null || openClass1.getInstanceClass().isPrimitive() && openClass1.getInstanceClass().isPrimitive() || !ret.getInstanceClass().isPrimitive())) {
            return JavaOpenClass.getOpenClass(ClassUtils.primitiveToWrapper(ret.getInstanceClass()));
        }
        return ret;
    }

    private static void addClassToCandidates(IOpenClass openClass, Set<IOpenClass> candidates) {
        if (openClass.getInstanceClass() != null) {
            if (openClass.getInstanceClass().isPrimitive()) {
                candidates.add(openClass);
                candidates.add(JavaOpenClass.getOpenClass(ClassUtils.primitiveToWrapper(openClass.getInstanceClass())));
            } else {
                candidates.add(openClass);
                Class t = ClassUtils.wrapperToPrimitive(openClass.getInstanceClass());
                if (t != null) {
                    candidates.add(JavaOpenClass.getOpenClass(t));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOpenCast getCast(IOpenClass from, IOpenClass to) {
        if (from == to || from.equals(to)) {
            return JAVA_NO_CAST;
        }
        if (to == NullOpenClass.the) {
            return null;
        }
        if (from == NullOpenClass.the) {
            if (this.isPrimitive(to)) {
                return null;
            }
            return JAVA_UP_CAST;
        }
        if (ThrowableVoidCast.ThrowableVoid.class.equals(from.getInstanceClass())) {
            return THROWABLE_VOID_CAST;
        }
        GenericKey key = GenericKey.getInstance(from, to);
        Lock readLock = this.castCacheLock.readLock();
        try {
            readLock.lock();
            IOpenCast cast = this.castCache.get(key);
            if (cast != null) {
                IOpenCast iOpenCast = cast;
                return iOpenCast;
            }
        }
        finally {
            readLock.unlock();
        }
        IOpenCast typeCast = this.findCast(from, to);
        Lock writeLock = this.castCacheLock.writeLock();
        try {
            writeLock.lock();
            this.castCache.put(key, typeCast);
        }
        finally {
            writeLock.unlock();
        }
        return typeCast;
    }

    private IOpenCast findCast(IOpenClass from, IOpenClass to) {
        IOpenCast typeCast = this.findArrayCast(from, to);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findAliasCast(from, to);
        IOpenCast javaCast = this.findJavaCast(from, to);
        typeCast = this.useCastWithBetterDistance(from, to, typeCast, javaCast);
        IOpenCast methodBasedCast = this.findMethodBasedCast(from, to, this.methodFactory);
        typeCast = this.useCastWithBetterDistance(from, to, typeCast, methodBasedCast);
        return typeCast;
    }

    private IOpenCast useCastWithBetterDistance(IOpenClass from, IOpenClass to, IOpenCast typeCast, IOpenCast javaCast) {
        if (typeCast == null) {
            typeCast = javaCast;
        } else if (javaCast != null && typeCast.getDistance(from, to) > javaCast.getDistance(from, to)) {
            typeCast = javaCast;
        }
        return typeCast;
    }

    private IOpenCast getUpCast(Class<?> from, Class<?> to) {
        if (from.isArray() && to.isArray()) {
            return JAVA_UP_ARRAY_TO_ARRAY_CAST;
        }
        return JAVA_UP_CAST;
    }

    private IOpenCast findArrayCast(IOpenClass from, IOpenClass to) {
        IOpenClass componentClass;
        IOpenCast cast;
        Class<?> fromClass = from.getInstanceClass();
        if ((from.isArray() || Object.class.equals(fromClass)) && to.isArray()) {
            if (to.getInstanceClass().isAssignableFrom(fromClass) && !(to instanceof DomainOpenClass)) {
                return this.getUpCast(fromClass, to.getInstanceClass());
            }
            int dimf = 0;
            IOpenClass f = from;
            while (f.isArray()) {
                f = f.getComponentClass();
                ++dimf;
            }
            IOpenClass t = to;
            int dimt = 0;
            while (t.isArray()) {
                t = t.getComponentClass();
                ++dimt;
            }
            if (to instanceof DomainOpenClass) {
                t = to.getAggregateInfo().getComponentType(to);
            }
            if (dimf == dimt || Object.class.equals(fromClass)) {
                IOpenCast arrayElementCast = this.getCast(f, t);
                if (arrayElementCast == null && Object.class.equals(fromClass)) {
                    arrayElementCast = JAVA_NO_CAST;
                }
                if (arrayElementCast != null) {
                    return new ArrayCast(t, arrayElementCast, dimt);
                }
            }
        }
        if (!from.isArray() && to.isArray() && !to.getComponentClass().isArray() && (cast = this.getCast(from, componentClass = to.getComponentClass())) != null) {
            return new OneElementArrayCast(componentClass, cast);
        }
        return null;
    }

    public ICastFactory getGlobalCastFactory() {
        if (this.globalCastFactory == null) {
            return this;
        }
        return this.globalCastFactory;
    }

    public void setGlobalCastFactory(ICastFactory globalCastFactory) {
        this.globalCastFactory = globalCastFactory;
    }

    private boolean isPrimitive(IOpenClass openClass) {
        return openClass != null && openClass.getInstanceClass() != null && openClass.getInstanceClass().isPrimitive();
    }

    private IOpenCast findJavaCast(IOpenClass from, IOpenClass to) {
        Class<?> fromClass = from.getInstanceClass();
        Class<?> toClass = to.getInstanceClass();
        if (ConstrainerObject.class.isAssignableFrom(fromClass)) {
            return null;
        }
        if (toClass.isAssignableFrom(fromClass)) {
            return this.getUpCast(fromClass, toClass);
        }
        IOpenCast typeCast = this.findBoxingCast(from, to);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findUnBoxingCast(from, to);
        if (typeCast != null) {
            return typeCast;
        }
        if (this.isAllowJavaDowncast(fromClass, toClass)) {
            return new JavaDownCast(to, this.getGlobalCastFactory());
        }
        return null;
    }

    private IOpenCast findBoxingCast(IOpenClass from, IOpenClass to) {
        Class<?> toClass;
        if (from == null || to == null || !this.isPrimitive(from) || this.isPrimitive(to)) {
            return null;
        }
        Class<?> fromClass = from.getInstanceClass();
        if (fromClass == ClassUtils.wrapperToPrimitive(toClass = to.getInstanceClass())) {
            return JAVA_BOXING_CAST;
        }
        if (toClass.isAssignableFrom(ClassUtils.primitiveToWrapper(fromClass))) {
            return JAVA_BOXING_UP_CAST;
        }
        if (fromClass == Void.TYPE && toClass == Void.class) {
            return JAVA_BOXING_CAST;
        }
        return null;
    }

    private IOpenCast findUnBoxingCast(IOpenClass from, IOpenClass to) {
        if (from == null || to == null || this.isPrimitive(from) || !this.isPrimitive(to)) {
            return null;
        }
        Class<?> fromClass = from.getInstanceClass();
        Class<?> toClass = to.getInstanceClass();
        if (toClass == ClassUtils.wrapperToPrimitive(fromClass)) {
            return JAVA_UNBOXING_CAST;
        }
        if (fromClass == Void.class && toClass == Void.TYPE) {
            return JAVA_UNBOXING_CAST;
        }
        return null;
    }

    private IOpenCast findAliasCast(IOpenClass from, IOpenClass to) {
        if (!from.isArray() && (from instanceof DomainOpenClass || to instanceof DomainOpenClass)) {
            if (from instanceof DomainOpenClass && !(to instanceof DomainOpenClass) && to.getInstanceClass().isAssignableFrom(from.getInstanceClass())) {
                return new AliasToTypeCast(from, to);
            }
            if (to instanceof DomainOpenClass && !(from instanceof DomainOpenClass) && from.getInstanceClass().isAssignableFrom(to.getInstanceClass())) {
                return new TypeToAliasCast(from, to);
            }
            if (to instanceof DomainOpenClass && !(from instanceof DomainOpenClass) && this.isPrimitive(from) && ClassUtils.primitiveToWrapper(from.getInstanceClass()).isAssignableFrom(to.getInstanceClass())) {
                return new TypeToAliasWithJavaBoxingCast(from, to);
            }
            if (to instanceof DomainOpenClass && !(from instanceof DomainOpenClass) && org.apache.commons.lang3.ClassUtils.isPrimitiveWrapper(from.getInstanceClass()) && ClassUtils.wrapperToPrimitive(from.getInstanceClass()).isAssignableFrom(to.getInstanceClass())) {
                return new TypeToAliasWithJavaUnboxingCast(from, to);
            }
            if (from instanceof DomainOpenClass && to.getInstanceClass().isAssignableFrom(from.getClass())) {
                return JAVA_UP_CAST;
            }
        }
        return null;
    }

    private IOpenCast findMethodBasedCast(IOpenClass from, IOpenClass to, IMethodFactory methodFactory) {
        IOpenCast typeCast = this.findMethodCast(from, to, methodFactory);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findMethodCast(from, to, from);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findMethodCast(from, to, to);
        if (typeCast != null) {
            return typeCast;
        }
        return null;
    }

    private IOpenCast findMethodCast(IOpenClass from, IOpenClass to, IMethodFactory methodFactory) {
        JavaOpenClass wrapperOpenClassTo;
        JavaOpenClass wrapperOpenClassTo2;
        JavaOpenClass wrapperOpenClassFrom;
        if (methodFactory == null) {
            return null;
        }
        boolean auto = true;
        int distance = from.getInstanceClass().isPrimitive() && !to.getInstanceClass().isPrimitive() ? 8 : (!from.getInstanceClass().isPrimitive() && to.getInstanceClass().isPrimitive() ? 14 : (!from.getInstanceClass().isPrimitive() && !to.getInstanceClass().isPrimitive() ? 12 : 5));
        IOpenMethod castCaller = null;
        Object toNullObject = to.nullObject();
        IOpenClass fromOpenClass = from;
        IOpenClass toOpenClass = to;
        Class primitiveClassFrom = ClassUtils.wrapperToPrimitive(from.getInstanceClass());
        Class primitiveClassTo = ClassUtils.wrapperToPrimitive(to.getInstanceClass());
        try {
            castCaller = methodFactory.getMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{from, to});
            if (castCaller == null && primitiveClassFrom != null) {
                wrapperOpenClassFrom = JavaOpenClass.getOpenClass(primitiveClassFrom);
                fromOpenClass = wrapperOpenClassFrom;
                toOpenClass = to;
                castCaller = methodFactory.getMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{wrapperOpenClassFrom, to});
            }
            if (castCaller == null && primitiveClassTo != null) {
                wrapperOpenClassTo2 = JavaOpenClass.getOpenClass(primitiveClassTo);
                castCaller = methodFactory.getMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{from, wrapperOpenClassTo2});
                fromOpenClass = from;
                toOpenClass = wrapperOpenClassTo2;
                toNullObject = wrapperOpenClassTo2.nullObject();
            }
            if (castCaller == null && primitiveClassFrom != null && primitiveClassTo != null) {
                wrapperOpenClassFrom = JavaOpenClass.getOpenClass(primitiveClassFrom);
                wrapperOpenClassTo = JavaOpenClass.getOpenClass(primitiveClassTo);
                fromOpenClass = wrapperOpenClassFrom;
                toOpenClass = wrapperOpenClassTo;
                castCaller = methodFactory.getMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{wrapperOpenClassFrom, wrapperOpenClassTo});
            }
        }
        catch (AmbiguousMethodException wrapperOpenClassFrom2) {
            // empty catch block
        }
        if (castCaller == null) {
            auto = false;
            try {
                castCaller = methodFactory.getMethod(CAST_METHOD_NAME, new IOpenClass[]{from, to});
                distance = from.getInstanceClass().isPrimitive() && !to.getInstanceClass().isPrimitive() ? 34 : (!from.getInstanceClass().isPrimitive() && to.getInstanceClass().isPrimitive() ? 33 : (!from.getInstanceClass().isPrimitive() && !to.getInstanceClass().isPrimitive() ? 32 : 31));
                if (castCaller == null && primitiveClassFrom != null) {
                    wrapperOpenClassFrom = JavaOpenClass.getOpenClass(primitiveClassFrom);
                    fromOpenClass = wrapperOpenClassFrom;
                    toOpenClass = to;
                    castCaller = methodFactory.getMethod(CAST_METHOD_NAME, new IOpenClass[]{wrapperOpenClassFrom, to});
                }
                if (castCaller == null && primitiveClassTo != null) {
                    wrapperOpenClassTo2 = JavaOpenClass.getOpenClass(primitiveClassTo);
                    castCaller = methodFactory.getMethod(CAST_METHOD_NAME, new IOpenClass[]{from, wrapperOpenClassTo2});
                    fromOpenClass = from;
                    toOpenClass = wrapperOpenClassTo2;
                    toNullObject = wrapperOpenClassTo2.nullObject();
                }
                if (castCaller == null && primitiveClassFrom != null && primitiveClassTo != null) {
                    wrapperOpenClassFrom = JavaOpenClass.getOpenClass(primitiveClassFrom);
                    wrapperOpenClassTo = JavaOpenClass.getOpenClass(primitiveClassTo);
                    fromOpenClass = wrapperOpenClassFrom;
                    toOpenClass = wrapperOpenClassTo;
                    castCaller = methodFactory.getMethod(CAST_METHOD_NAME, new IOpenClass[]{wrapperOpenClassFrom, wrapperOpenClassTo});
                }
            }
            catch (AmbiguousMethodException wrapperOpenClassFrom3) {
                // empty catch block
            }
        }
        if (castCaller == null) {
            return null;
        }
        IOpenMethod distanceCaller = null;
        try {
            distanceCaller = methodFactory.getMethod(DISTANCE_METHOD_NAME, new IOpenClass[]{fromOpenClass, toOpenClass});
        }
        catch (AmbiguousMethodException ambiguousMethodException) {
            // empty catch block
        }
        if (distanceCaller != null) {
            distance = (Integer)distanceCaller.invoke(null, new Object[]{fromOpenClass.nullObject(), toOpenClass.nullObject()}, null);
        }
        return new MethodBasedCast(castCaller, auto, distance, toNullObject);
    }

    private boolean isAllowJavaDowncast(Class<?> from, Class<?> to) {
        if (from.isAssignableFrom(to)) {
            return true;
        }
        if (!from.isPrimitive() && to.isInterface()) {
            return true;
        }
        return !to.isPrimitive() && from.isInterface();
    }

    public IMethodFactory getMethodFactory() {
        return this.methodFactory;
    }
}

