/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.cast;

import org.openl.binding.impl.cast.IOpenCast;
import org.openl.types.IOpenClass;

public class CastsLinkageCast
implements IOpenCast {
    private IOpenCast[] casts;

    public CastsLinkageCast(IOpenCast ... casts) {
        if (casts == null) {
            throw new IllegalArgumentException();
        }
        this.casts = casts;
    }

    @Override
    public Object convert(Object from) {
        if (from == null) {
            return null;
        }
        Object ret = from;
        for (IOpenCast cast : this.casts) {
            ret = cast.convert(ret);
        }
        return ret;
    }

    @Override
    public int getDistance(IOpenClass from, IOpenClass to) {
        int distance = 0;
        for (IOpenCast cast : this.casts) {
            int d = cast.getDistance(from, to);
            if (distance >= d) continue;
            distance = d;
        }
        return distance;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }
}

