/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.cast;

import org.openl.binding.ICastFactory;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class JavaDownCast
implements IOpenCast {
    private IOpenClass to;
    private ICastFactory castFactory;

    public JavaDownCast(IOpenClass to, ICastFactory castFactory) {
        if (to == null) {
            throw new IllegalArgumentException("to arg can't be null!");
        }
        if (castFactory == null) {
            throw new IllegalArgumentException("castFactory arg can't be null!");
        }
        this.to = to;
        this.castFactory = castFactory;
    }

    @Override
    public Object convert(Object from) {
        if (from == null) {
            return null;
        }
        if (from.getClass().isAssignableFrom(this.to.getInstanceClass())) {
            return from;
        }
        if (this.to.getInstanceClass().isAssignableFrom(from.getClass())) {
            return from;
        }
        IOpenCast openCast = this.castFactory.getCast(JavaOpenClass.getOpenClass(from.getClass()), this.to);
        if (openCast != null && !(openCast instanceof JavaDownCast)) {
            return openCast.convert(from);
        }
        throw new ClassCastException("Can't cast from '" + from.getClass().getCanonicalName() + "' to " + this.to.getDisplayName(0));
    }

    @Override
    public int getDistance(IOpenClass from, IOpenClass to) {
        return 30;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }
}

