/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.cast;

import java.lang.reflect.Array;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.cast.IgnoredByMethodSearchOpenCast;
import org.openl.types.IOpenClass;

public class OneElementArrayCast
implements IOpenCast,
IgnoredByMethodSearchOpenCast {
    private IOpenClass toComponentType;
    private IOpenCast openCast;

    public OneElementArrayCast(IOpenClass to, IOpenCast openCast) {
        if (to == null) {
            throw new IllegalArgumentException("to arg can't be null!");
        }
        if (to.isArray()) {
            throw new IllegalArgumentException("to arg can't be array type!");
        }
        this.toComponentType = to;
        this.openCast = openCast;
    }

    @Override
    public Object convert(Object from) {
        if (from == null) {
            return null;
        }
        Object array = Array.newInstance(this.toComponentType.getInstanceClass(), 1);
        Array.set(array, 0, this.openCast.convert(from));
        return array;
    }

    @Override
    public int getDistance(IOpenClass from, IOpenClass to) {
        return 2000 + this.openCast.getDistance(from, to);
    }

    @Override
    public boolean isImplicit() {
        return this.openCast.isImplicit();
    }
}

