/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.component;

import java.util.HashMap;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.ICastFactory;
import org.openl.binding.ILocalVar;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.exception.AmbiguousVarException;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.binding.impl.method.MethodSearch;
import org.openl.exception.OpenLCompilationException;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;

public class ComponentBindingContext
extends BindingContextDelegator {
    private ComponentOpenClass componentOpenClass;
    private Map<String, IOpenClass> internalTypes = null;

    public ComponentBindingContext(IBindingContext delegate, ComponentOpenClass componentOpenClass) {
        super(delegate);
        this.componentOpenClass = componentOpenClass;
    }

    private String buildTypeName(String namespace, String typeName) {
        StringBuilder builder = new StringBuilder(64);
        return builder.append(namespace).append("::").append(typeName).toString();
    }

    public ComponentOpenClass getComponentOpenClass() {
        return this.componentOpenClass;
    }

    @Override
    public synchronized void addType(String namespace, IOpenClass type) throws OpenLCompilationException {
        this.add(namespace, type.getName(), type);
    }

    protected synchronized void add(String namespace, String typeName, IOpenClass type) throws OpenLCompilationException {
        String nameWithNamespace;
        if (this.internalTypes == null) {
            this.internalTypes = new HashMap<String, IOpenClass>();
        }
        if (this.internalTypes.containsKey(nameWithNamespace = this.buildTypeName(namespace, typeName))) {
            IOpenClass openClass = this.internalTypes.get(nameWithNamespace);
            if (openClass == type) {
                return;
            }
            throw new OpenLCompilationException("Type " + nameWithNamespace + " has been defined already");
        }
        this.internalTypes.put(nameWithNamespace, type);
    }

    @Override
    public ILocalVar addVar(String namespace, String name, IOpenClass type) throws DuplicatedVarException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodCaller findMethodCaller(String namespace, String methodName, IOpenClass[] parTypes) throws AmbiguousMethodException {
        IMethodCaller imc = null;
        if ("org.openl.this".equals(namespace)) {
            imc = MethodSearch.findMethod(methodName, parTypes, (ICastFactory)this, this.componentOpenClass);
        }
        return imc != null ? imc : super.findMethodCaller(namespace, methodName, parTypes);
    }

    @Override
    public IOpenClass findType(String namespace, String typeName) {
        IOpenClass ioc;
        String key = this.buildTypeName(namespace, typeName);
        if (this.internalTypes != null && (ioc = this.internalTypes.get(key)) != null) {
            return ioc;
        }
        IOpenClass type = this.componentOpenClass.findType(typeName);
        if (type != null) {
            return type;
        }
        return super.findType(namespace, typeName);
    }

    @Override
    public IOpenField findVar(String namespace, String name, boolean strictMatch) throws AmbiguousVarException {
        IOpenField res = null;
        if (namespace.equals("org.openl.this")) {
            res = this.componentOpenClass.getField(name, strictMatch);
        }
        return res != null ? res : super.findVar(namespace, name, strictMatch);
    }
}

