/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.method;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.impl.cast.CastsLinkageCast;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.cast.IgnoredByMethodSearchOpenCast;
import org.openl.binding.impl.method.AutoCastableResultOpenMethod;
import org.openl.binding.impl.method.VarArgsOpenMethod;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CastingMethodCaller;
import org.openl.types.java.JavaOpenClass;
import org.openl.types.java.JavaOpenMethod;
import org.openl.util.ClassUtils;
import org.openl.util.CollectionUtils;
import org.openl.util.JavaGenericsUtils;
import org.openl.util.OpenClassUtils;

public class MethodSearch {
    static final int[] NO_MATCH = new int[0];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int[] calcMatch(JavaOpenMethod method, IOpenClass[] methodParam, IOpenClass[] callParam, ICastFactory casts, IOpenCast[] castHolder, IOpenCast[] returnCastHolder, IOpenClass[] returnTypeHolder) {
        int i;
        Object m;
        Integer[] castHolderDistance = new Integer[callParam.length];
        if (method != null) {
            m = new HashMap();
            String[] typeNames = new String[method.getParameterTypes().length];
            int[] arrayDims = new int[method.getParameterTypes().length];
            int i2 = 0;
            for (Type type : method.getJavaMethod().getGenericParameterTypes()) {
                typeNames[i2] = JavaGenericsUtils.getGenericTypeName((Type)type);
                if (typeNames[i2] != null) {
                    arrayDims[i2] = JavaGenericsUtils.getGenericTypeDim((Type)type);
                    int arrayDim = arrayDims[i2];
                    IOpenClass t = callParam[i2];
                    if (t.getInstanceClass() != null) {
                        t = JavaOpenClass.getOpenClass(t.getInstanceClass());
                    }
                    if (t.getInstanceClass() != null && t.getInstanceClass().isPrimitive()) {
                        t = JavaOpenClass.getOpenClass(ClassUtils.primitiveToWrapper(t.getInstanceClass()));
                    }
                    while (t.isArray() && arrayDim > 0) {
                        --arrayDim;
                        t = t.getComponentClass();
                    }
                    if (arrayDim > 0) {
                        return NO_MATCH;
                    }
                    if (t.isArray()) {
                        t = JavaOpenClass.OBJECT;
                    }
                    if (m.containsKey(typeNames[i2])) {
                        IOpenClass existedType = (IOpenClass)m.get(typeNames[i2]);
                        IOpenCast cast1 = casts.getCast(existedType, t);
                        IOpenCast cast2 = casts.getCast(t, existedType);
                        if (!(cast1 != null && cast1.isImplicit() || cast2 != null && cast2.isImplicit())) {
                            IOpenClass clazz = casts.findClosestClass(t, existedType);
                            if (clazz != null && clazz.getInstanceClass() != null && clazz.getInstanceClass().isPrimitive()) {
                                clazz = JavaOpenClass.getOpenClass(ClassUtils.primitiveToWrapper(clazz.getInstanceClass()));
                            }
                            if (clazz == null) return NO_MATCH;
                            m.put(typeNames[i2], clazz);
                        } else if (cast1 != null && cast1.isImplicit()) {
                            if (cast2 == null || !cast2.isImplicit()) {
                                m.put(typeNames[i2], t);
                            } else if (cast2.getDistance(t, existedType) < cast1.getDistance(existedType, t)) {
                                m.put(typeNames[i2], t);
                            }
                        }
                    } else {
                        m.put(typeNames[i2], t);
                    }
                }
                ++i2;
            }
            String returnType = JavaGenericsUtils.getGenericTypeName((Type)method.getJavaMethod().getGenericReturnType());
            if (returnType != null && m.containsKey(returnType)) {
                IOpenCast returnCast;
                int dim = JavaGenericsUtils.getGenericTypeDim((Type)method.getJavaMethod().getGenericReturnType());
                IOpenClass type = (IOpenClass)m.get(returnType);
                if (dim > 0) {
                    type = type.getArrayType(dim);
                }
                if ((returnCast = casts.getCast(method.getType(), type)) == null) {
                    return NO_MATCH;
                }
                returnCastHolder[0] = returnCast;
                returnTypeHolder[0] = type;
            }
            for (i2 = 0; i2 < callParam.length; ++i2) {
                if (typeNames[i2] != null) {
                    IOpenClass type = (IOpenClass)m.get(typeNames[i2]);
                    if (arrayDims[i2] > 0) {
                        type = type.getArrayType(arrayDims[i2]);
                    }
                    if (callParam[i2] != type) {
                        IOpenCast gCast = casts.getCast(callParam[i2], type);
                        if (type != methodParam[i2]) {
                            IOpenCast cast = casts.getCast(type, methodParam[i2]);
                            if (cast == null || !cast.isImplicit()) {
                                return NO_MATCH;
                            }
                            castHolder[i2] = new CastsLinkageCast(gCast, cast);
                        } else {
                            castHolder[i2] = gCast;
                        }
                        castHolderDistance[i2] = gCast.getDistance(callParam[i2], type);
                        continue;
                    }
                    if (callParam[i2] == methodParam[i2]) continue;
                    castHolder[i2] = casts.getCast(callParam[i2], methodParam[i2]);
                    if (castHolder[i2] == null || !castHolder[i2].isImplicit()) {
                        return NO_MATCH;
                    }
                    castHolderDistance[i2] = 0;
                    continue;
                }
                if (callParam[i2] == methodParam[i2]) continue;
                castHolder[i2] = casts.getCast(callParam[i2], methodParam[i2]);
                if (castHolder[i2] != null && castHolder[i2].isImplicit()) continue;
                return NO_MATCH;
            }
        } else {
            for (int i3 = 0; i3 < callParam.length; ++i3) {
                if (callParam[i3] == methodParam[i3]) continue;
                IOpenCast cast = casts.getCast(callParam[i3], methodParam[i3]);
                if (cast == null || !cast.isImplicit()) {
                    return NO_MATCH;
                }
                castHolder[i3] = cast;
            }
        }
        m = new int[callParam.length];
        for (i = 0; i < callParam.length; ++i) {
            if (castHolder[i] == null) continue;
            m[i] = castHolderDistance[i] == null ? (Object)castHolder[i].getDistance(callParam[i], methodParam[i]) : (Object)castHolderDistance[i];
        }
        for (i = 0; i < castHolder.length; ++i) {
            if (!(castHolder[i] instanceof IgnoredByMethodSearchOpenCast)) continue;
            return NO_MATCH;
        }
        return m;
    }

    private static final boolean zeroCasts(int[] m) {
        for (int i = 0; i < m.length; ++i) {
            if (m[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static final boolean lq(int[] m1, int[] m2) {
        if (m1 == NO_MATCH) {
            return false;
        }
        if (m2 == NO_MATCH) {
            return true;
        }
        int[] d1 = (int[])m1.clone();
        int[] d2 = (int[])m2.clone();
        Arrays.sort(d1);
        Arrays.sort(d2);
        for (int i = d1.length - 1; i >= 0; --i) {
            if (d1[i] < d2[i]) {
                return true;
            }
            if (d1[i] <= d2[i]) continue;
            return false;
        }
        return false;
    }

    private static final boolean eq(int[] distances1, int[] distances2) {
        if (distances1 == distances2) {
            return true;
        }
        if (distances1.length != distances2.length) {
            return false;
        }
        int[] d1 = (int[])distances1.clone();
        int[] d2 = (int[])distances2.clone();
        Arrays.sort(d1);
        Arrays.sort(d2);
        for (int i = d1.length - 1; i >= 0; --i) {
            if (d1[i] == d2[i]) continue;
            return false;
        }
        return true;
    }

    private static IMethodCaller findCastingMethod(final String name, IOpenClass[] params, ICastFactory casts, Iterable<IOpenMethod> methods) throws AmbiguousMethodException {
        final int nParams = params.length;
        List filtered = methods == null ? Collections.emptyList() : CollectionUtils.findAll(methods, (CollectionUtils.Predicate)new CollectionUtils.Predicate<IOpenMethod>(){

            public boolean evaluate(IOpenMethod method) {
                return method.getName().equals(name) && method.getSignature().getParameterTypes().length == nParams;
            }
        });
        ArrayList<IOpenMethod> matchingMethods = new ArrayList<IOpenMethod>();
        ArrayList<IOpenCast[]> matchingMethodsCastHolder = new ArrayList<IOpenCast[]>();
        ArrayList<IOpenCast> matchingMethodsReturnCast = new ArrayList<IOpenCast>();
        ArrayList<IOpenClass> matchingMethodsReturnType = new ArrayList<IOpenClass>();
        int[] bestMatch = NO_MATCH;
        for (IOpenMethod method : filtered) {
            int[] match;
            IOpenCast[] castHolder = new IOpenCast[nParams];
            IOpenCast[] returnCastHolder = new IOpenCast[1];
            IOpenClass[] returnTypeHolder = new IOpenClass[1];
            if (method instanceof JavaOpenMethod) {
                JavaOpenMethod javaOpenMethod = (JavaOpenMethod)method;
                match = MethodSearch.calcMatch(javaOpenMethod, method.getSignature().getParameterTypes(), params, casts, castHolder, returnCastHolder, returnTypeHolder);
            } else {
                match = MethodSearch.calcMatch(null, method.getSignature().getParameterTypes(), params, casts, castHolder, returnCastHolder, returnTypeHolder);
            }
            if (match == NO_MATCH) continue;
            if (MethodSearch.lq(match, bestMatch)) {
                bestMatch = match;
                matchingMethods.clear();
                matchingMethodsCastHolder.clear();
                matchingMethodsReturnCast.clear();
                matchingMethodsReturnType.clear();
                matchingMethods.add(method);
                matchingMethodsCastHolder.add(castHolder);
                matchingMethodsReturnCast.add(returnCastHolder[0]);
                matchingMethodsReturnType.add(returnTypeHolder[0]);
                continue;
            }
            if (!MethodSearch.eq(match, bestMatch)) continue;
            matchingMethods.add(method);
            matchingMethodsCastHolder.add(castHolder);
            matchingMethodsReturnCast.add(returnCastHolder[0]);
            matchingMethodsReturnType.add(returnTypeHolder[0]);
        }
        switch (matchingMethods.size()) {
            case 0: {
                return null;
            }
            case 1: {
                IOpenMethod m = (IOpenMethod)matchingMethods.get(0);
                if (!MethodSearch.zeroCasts(bestMatch)) {
                    CastingMethodCaller methodCaller = new CastingMethodCaller(m, (IOpenCast[])matchingMethodsCastHolder.get(0));
                    return MethodSearch.buildMethod((IOpenCast)matchingMethodsReturnCast.get(0), (IOpenClass)matchingMethodsReturnType.get(0), m, methodCaller);
                }
                return MethodSearch.buildMethod((IOpenCast)matchingMethodsReturnCast.get(0), (IOpenClass)matchingMethodsReturnType.get(0), m, m);
            }
        }
        IOpenMethod mostSecificMethod = MethodSearch.findMostSpecificMethod(name, params, matchingMethods, casts);
        boolean f = true;
        for (int i = 0; i < nParams; ++i) {
            if (params[i].equals(mostSecificMethod.getSignature().getParameterType(i))) continue;
            f = false;
            break;
        }
        if (f) {
            return mostSecificMethod;
        }
        int k = 0;
        for (int i = 0; i < matchingMethods.size(); ++i) {
            if (matchingMethods.get(i) != mostSecificMethod) continue;
            k = i;
            break;
        }
        CastingMethodCaller methodCaller = new CastingMethodCaller(mostSecificMethod, (IOpenCast[])matchingMethodsCastHolder.get(k));
        IOpenCast c = (IOpenCast)matchingMethodsReturnCast.get(k);
        IOpenClass t = (IOpenClass)matchingMethodsReturnType.get(k);
        if (c != null && t != mostSecificMethod.getType()) {
            return new AutoCastableResultOpenMethod(methodCaller.getMethod(), t, c);
        }
        return methodCaller;
    }

    private static IMethodCaller buildMethod(IOpenCast methodsReturnCast, IOpenClass methodsReturnType, IOpenMethod m, IMethodCaller methodCaller) {
        if (methodsReturnCast != null && methodsReturnType != m.getType()) {
            return new AutoCastableResultOpenMethod(methodCaller.getMethod(), methodsReturnType, methodsReturnCast);
        }
        return methodCaller;
    }

    private static IMethodCaller findVarArgMethod(final String name, IOpenClass[] params, ICastFactory casts, Iterable<IOpenMethod> methods) throws AmbiguousMethodException {
        List filtered;
        List list = filtered = methods == null ? Collections.emptyList() : CollectionUtils.findAll(methods, (CollectionUtils.Predicate)new CollectionUtils.Predicate<IOpenMethod>(){

            public boolean evaluate(IOpenMethod method) {
                return method.getName().equals(name) && method.getSignature().getNumberOfParameters() > 0 && method.getSignature().getParameterType(method.getSignature().getNumberOfParameters() - 1).isArray();
            }
        });
        if (filtered.iterator().hasNext()) {
            IOpenClass varArgType;
            IOpenClass[] args;
            int i;
            for (i = params.length - 1; i >= 0; --i) {
                args = new IOpenClass[i + 1];
                System.arraycopy(params, 0, args, 0, i);
                varArgType = params[i];
                for (int j = i + 1; j < params.length && (varArgType = OpenClassUtils.findParentClassWithBoxing(varArgType, params[j])) != null; ++j) {
                }
                if (varArgType == null) continue;
                args[i] = NullOpenClass.isAnyNull(varArgType) ? varArgType : varArgType.getAggregateInfo().getIndexedAggregateType(varArgType, 1);
                IMethodCaller matchedMethod = MethodSearch.findCastingMethod(name, args, casts, filtered);
                if (matchedMethod == null) continue;
                if (NullOpenClass.isAnyNull(varArgType)) {
                    int lastParameterIndex = matchedMethod.getMethod().getSignature().getNumberOfParameters() - 1;
                    return new VarArgsOpenMethod(matchedMethod, matchedMethod.getMethod().getSignature().getParameterType(lastParameterIndex).getComponentClass().getInstanceClass(), i);
                }
                return new VarArgsOpenMethod(matchedMethod, varArgType.getInstanceClass(), i);
            }
            for (i = params.length - 1; i >= 0; --i) {
                args = new IOpenClass[i + 1];
                System.arraycopy(params, 0, args, 0, i);
                varArgType = params[i];
                for (int j = i + 1; j < params.length && (varArgType = casts.findClosestClass(varArgType, params[j])) != null; ++j) {
                }
                if (varArgType == null) continue;
                args[i] = NullOpenClass.isAnyNull(varArgType) ? varArgType : varArgType.getAggregateInfo().getIndexedAggregateType(varArgType, 1);
                args[i] = varArgType.getAggregateInfo().getIndexedAggregateType(varArgType, 1);
                IMethodCaller matchedMethod = MethodSearch.findCastingMethod(name, args, casts, filtered);
                if (matchedMethod == null) continue;
                IOpenCast[] parameterCasts = new IOpenCast[params.length - i];
                for (int j = 0; j < params.length - i; ++j) {
                    parameterCasts[j] = casts.getCast(params[i + j], varArgType);
                }
                if (NullOpenClass.isAnyNull(varArgType)) {
                    int lastParameterIndex = matchedMethod.getMethod().getSignature().getNumberOfParameters() - 1;
                    return new VarArgsOpenMethod(matchedMethod, matchedMethod.getMethod().getSignature().getParameterType(lastParameterIndex).getComponentClass().getInstanceClass(), i, parameterCasts);
                }
                return new VarArgsOpenMethod(matchedMethod, varArgType.getInstanceClass(), i, parameterCasts);
            }
        }
        return null;
    }

    private static IMethodCaller findCastingMethod(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        return MethodSearch.findCastingMethod(name, params, casts, factory.methods(name));
    }

    private static IMethodCaller findVarArgMethod(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        return MethodSearch.findVarArgMethod(name, params, casts, factory.methods(name));
    }

    private static IMethodCaller findCastingConstructor(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        return MethodSearch.findCastingMethod(name, params, casts, factory.constructors(name));
    }

    private static IMethodCaller findVarArgConstructor(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        return MethodSearch.findCastingMethod(name, params, casts, factory.constructors(name));
    }

    private static IOpenMethod findMostSpecificMethod(String name, IOpenClass[] params, List<IOpenMethod> matchingMethods, ICastFactory casts) throws AmbiguousMethodException {
        ArrayList<IOpenMethod> moreSpecificMethods = new ArrayList<IOpenMethod>();
        for (IOpenMethod res : matchingMethods) {
            boolean f = true;
            for (IOpenMethod next : matchingMethods) {
                if (res == next || MethodSearch.isMoreSpecificMethod(res, next, params, casts)) continue;
                f = false;
                break;
            }
            if (!f) continue;
            moreSpecificMethods.add(res);
        }
        if (moreSpecificMethods.size() == 1) {
            return (IOpenMethod)moreSpecificMethods.get(0);
        }
        ArrayList<IOpenMethod> mostSpecificMethods = new ArrayList<IOpenMethod>();
        int best1 = Integer.MAX_VALUE;
        int best2 = Integer.MAX_VALUE;
        for (IOpenMethod m : moreSpecificMethods) {
            int penalty1 = 0;
            int penalty2 = 0;
            if (m.getSignature().getNumberOfParameters() == params.length) {
                for (int i = 0; i < params.length; ++i) {
                    if (!params[i].getInstanceClass().isPrimitive() && m.getSignature().getParameterType(i).getInstanceClass().isPrimitive()) {
                        ++penalty1;
                    }
                    if (params[i].getInstanceClass().isPrimitive() == m.getSignature().getParameterType(i).getInstanceClass().isPrimitive()) continue;
                    ++penalty2;
                }
            }
            if (penalty1 < best1) {
                best1 = penalty1;
                best2 = penalty2;
                mostSpecificMethods.clear();
                mostSpecificMethods.add(m);
                continue;
            }
            if (penalty1 != best1) continue;
            if (penalty2 < best2) {
                best2 = penalty2;
                mostSpecificMethods.clear();
                mostSpecificMethods.add(m);
                continue;
            }
            if (penalty2 != best2) continue;
            mostSpecificMethods.add(m);
        }
        int countOfFoundMethods = mostSpecificMethods.size();
        if (countOfFoundMethods == 1) {
            return (IOpenMethod)mostSpecificMethods.get(0);
        }
        if (countOfFoundMethods == 0) {
            throw new AmbiguousMethodException(name, params, matchingMethods);
        }
        throw new AmbiguousMethodException(name, params, mostSpecificMethods);
    }

    private static boolean isMoreSpecificMethod(IOpenMethod first, IOpenMethod second, IOpenClass[] params, ICastFactory casts) {
        if (first.getSignature().getNumberOfParameters() != second.getSignature().getNumberOfParameters()) {
            return false;
        }
        boolean differenceInArgTypes = false;
        for (int i = 0; i < first.getSignature().getNumberOfParameters(); ++i) {
            IOpenClass secondArgType;
            IOpenClass firstArgType = first.getSignature().getParameterType(i);
            if (firstArgType.equals(secondArgType = second.getSignature().getParameterType(i)) || NullOpenClass.isAnyNull(params[i])) continue;
            differenceInArgTypes = true;
            IOpenCast cast = casts.getCast(firstArgType, secondArgType);
            if (cast != null && cast.isImplicit()) continue;
            return false;
        }
        if (!differenceInArgTypes) {
            IOpenClass secondDeclaringClass;
            IOpenClass firstDeclaringClass = first.getDeclaringClass();
            return !firstDeclaringClass.equals(secondDeclaringClass = second.getDeclaringClass()) && secondDeclaringClass.isAssignableFrom(firstDeclaringClass);
        }
        return true;
    }

    public static IMethodCaller findMethod(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        return MethodSearch.findMethod(name, params, casts, factory, false);
    }

    public static IMethodCaller findConstructor(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        return MethodSearch.findConstructor(name, params, casts, factory, false);
    }

    public static IMethodCaller findMethod(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory, boolean strictMatch) throws AmbiguousMethodException {
        IMethodCaller caller = factory.getMethod(name, params);
        if (caller != null) {
            return caller;
        }
        if (params.length == 0 || casts == null) {
            return null;
        }
        if (!strictMatch) {
            caller = MethodSearch.findCastingMethod(name, params, casts, factory);
            if (caller != null) {
                return caller;
            }
            return MethodSearch.findVarArgMethod(name, params, casts, factory);
        }
        return null;
    }

    public static IMethodCaller findMethod(String name, IOpenClass[] params, ICastFactory casts, Iterable<IOpenMethod> methods) throws AmbiguousMethodException {
        IMethodCaller caller = MethodSearch.findCastingMethod(name, params, casts, methods);
        if (caller != null) {
            return caller;
        }
        return MethodSearch.findVarArgMethod(name, params, casts, methods);
    }

    public static IMethodCaller findConstructor(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory, boolean strictMatch) throws AmbiguousMethodException {
        IMethodCaller caller = factory.getConstructor(name, params);
        if (caller != null) {
            return caller;
        }
        if (params.length == 0 || casts == null) {
            return null;
        }
        if (!strictMatch) {
            caller = MethodSearch.findCastingConstructor(name, params, casts, factory);
            if (caller != null) {
                return caller;
            }
            return MethodSearch.findVarArgConstructor(name, params, casts, factory);
        }
        return null;
    }
}

