/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.method;

import java.lang.reflect.Array;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.method.AOpenMethodDelegator;
import org.openl.types.IMethodCaller;
import org.openl.vm.IRuntimeEnv;

public class VarArgsOpenMethod
extends AOpenMethodDelegator {
    private int indexOfFirstVarArg;
    private Class<?> componentVarArgClass;
    private IOpenCast[] parameterCasts;
    private IMethodCaller methodCaller;

    public VarArgsOpenMethod(IMethodCaller methodCaller, Class<?> componentVarArgClass, int indexOfFirstVarArg) {
        this(methodCaller, componentVarArgClass, indexOfFirstVarArg, null);
    }

    public VarArgsOpenMethod(IMethodCaller methodCaller, Class<?> componentVarArgClass, int indexOfFirstVarArg, IOpenCast[] parameterCasts) {
        super(methodCaller.getMethod());
        this.methodCaller = methodCaller;
        this.componentVarArgClass = componentVarArgClass;
        this.indexOfFirstVarArg = indexOfFirstVarArg;
        this.parameterCasts = parameterCasts;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        return this.methodCaller.invoke(target, this.modifyParameters(params), env);
    }

    private Object[] modifyParameters(Object[] methodParameters) {
        int parametersCount = this.getSignature().getNumberOfParameters();
        Object[] modifiedParameters = new Object[parametersCount];
        System.arraycopy(methodParameters, 0, modifiedParameters, 0, this.indexOfFirstVarArg);
        modifiedParameters[parametersCount - 1] = this.buildVarArgsParameter(methodParameters);
        return modifiedParameters;
    }

    private Object buildVarArgsParameter(Object[] methodParameters) {
        int countOfParametersForVarArgs = methodParameters.length - this.indexOfFirstVarArg;
        Object params = Array.newInstance(this.componentVarArgClass, countOfParametersForVarArgs);
        for (int i = 0; i < countOfParametersForVarArgs; ++i) {
            if (this.parameterCasts == null) {
                Array.set(params, i, methodParameters[i + this.indexOfFirstVarArg]);
                continue;
            }
            Array.set(params, i, this.parameterCasts[i].convert(methodParameters[i + this.indexOfFirstVarArg]));
        }
        return params;
    }
}

