/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.dependency.CompiledDependency;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AMethod;
import org.openl.util.Log;

public class ModuleOpenClass
extends ComponentOpenClass {
    private ConcurrentHashMap<String, IOpenClass> internalTypes = new ConcurrentHashMap();
    private Collection<IOpenClass> types = Collections.unmodifiableCollection(this.internalTypes.values());
    private Set<CompiledDependency> usingModules = new HashSet<CompiledDependency>();
    private List<Throwable> errors = new ArrayList<Throwable>();
    private Map<String, IOpenField> dependencyFields = null;

    public ModuleOpenClass(String name, OpenL openl) {
        super(name, openl);
    }

    protected void initDependencies() throws OpenLCompilationException {
        for (CompiledDependency dependency : this.usingModules) {
            this.addDependencyTypes(dependency);
            this.addMethods(dependency);
        }
    }

    protected boolean shouldAddMethodFromDependency(IOpenMethod method) {
        return true;
    }

    protected void addMethods(CompiledDependency dependency) {
        CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
        for (IOpenMethod depMethod : compiledOpenClass.getOpenClassWithErrors().getMethods()) {
            if (depMethod.isConstructor() || depMethod instanceof ComponentOpenClass.GetOpenClass) continue;
            try {
                AMethod methodDependencyInfo;
                if (depMethod instanceof AMethod && (methodDependencyInfo = (AMethod)depMethod).getModuleName() == null) {
                    methodDependencyInfo.setModuleName(dependency.getDependencyName());
                }
                if (!this.shouldAddMethodFromDependency(depMethod)) continue;
                this.addMethod(depMethod);
            }
            catch (OpenlNotCheckedException e) {
                if (Log.isDebugEnabled()) {
                    Log.debug((Object)e.getMessage(), (Throwable)e);
                }
                this.addError(e);
            }
        }
    }

    @Override
    public IOpenField getField(String fname, boolean strictMatch) {
        IOpenField field = super.getField(fname, strictMatch);
        if (field != null) {
            return field;
        }
        for (CompiledDependency dependency : this.usingModules) {
            CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
            if (compiledOpenClass.hasErrors() || (field = compiledOpenClass.getOpenClass().getField(fname, strictMatch)) == null) continue;
            return field;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, IOpenField> getFields() {
        HashMap<String, IOpenField> fields = new HashMap<String, IOpenField>();
        if (this.dependencyFields == null) {
            ModuleOpenClass moduleOpenClass = this;
            synchronized (moduleOpenClass) {
                if (this.dependencyFields == null) {
                    this.dependencyFields = new HashMap<String, IOpenField>();
                    for (CompiledDependency dependency : this.usingModules) {
                        CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
                        if (compiledOpenClass.hasErrors()) continue;
                        this.dependencyFields.putAll(compiledOpenClass.getOpenClass().getFields());
                    }
                }
            }
        }
        fields.putAll(this.dependencyFields);
        fields.putAll(super.getFields());
        return fields;
    }

    public void setDependencies(Set<CompiledDependency> moduleDependencies) {
        if (moduleDependencies != null) {
            this.usingModules = new HashSet<CompiledDependency>(moduleDependencies);
        }
    }

    public Set<CompiledDependency> getDependencies() {
        if (this.usingModules == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.usingModules);
    }

    protected void addDependencyTypes(CompiledDependency dependency) {
        CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
        for (IOpenClass type : compiledOpenClass.getTypes()) {
            try {
                this.addType(type);
            }
            catch (OpenLCompilationException e) {
                this.addError(e);
            }
        }
    }

    @Override
    public Collection<IOpenClass> getTypes() {
        return this.types;
    }

    @Override
    public void addType(IOpenClass type) throws OpenLCompilationException {
        IOpenClass openClass = this.internalTypes.putIfAbsent(type.getName(), type);
        if (openClass != null && !openClass.equals(type)) {
            throw new OpenLCompilationException("The type " + type.getName() + " has been already defined.");
        }
    }

    @Override
    public IOpenClass findType(String name) {
        return this.internalTypes.get(name);
    }

    public void addError(Throwable error) {
        this.errors.add(error);
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }
}

