/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.operator;

import java.math.BigDecimal;
import java.util.Arrays;

public class Comparison {
    private static final BigDecimal HALF = new BigDecimal("0.5");
    private static final BigDecimal MAX_ULP = new BigDecimal("0.000001");

    public static boolean eq(boolean x, boolean y) {
        return x == y;
    }

    public static boolean eq(int x, int y) {
        return x == y;
    }

    public static boolean eq(long x, long y) {
        return x == y;
    }

    public static boolean eq(float x, float y) {
        if (x == y) {
            return true;
        }
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y)) {
            return Float.isNaN(x) && Float.isNaN(y);
        }
        return Math.abs(x - y) <= Math.ulp(x);
    }

    public static boolean eq(double x, double y) {
        if (x == y) {
            return true;
        }
        if (Double.isInfinite(x) || Double.isInfinite(y) || Double.isNaN(x) || Double.isNaN(y)) {
            return Double.isNaN(x) && Double.isNaN(y);
        }
        return Math.abs(x - y) <= Math.ulp(x);
    }

    public static boolean eq(Float x, Float y) {
        return x == null && y == null || x != null && y != null && Comparison.eq(x.floatValue(), y.floatValue());
    }

    public static boolean eq(Double x, Double y) {
        return x == null && y == null || x != null && y != null && Comparison.eq((double)x, (double)y);
    }

    public static boolean eq(BigDecimal x, BigDecimal y) {
        if (x != null && y != null) {
            BigDecimal yUlp;
            BigDecimal xUlp = x.ulp();
            BigDecimal ulp = xUlp.compareTo(yUlp = y.ulp()) > 0 ? xUlp : yUlp;
            if (MAX_ULP.compareTo(ulp) < 0) {
                ulp = MAX_ULP;
            }
            ulp = ulp.multiply(HALF);
            return x.subtract(y).abs().compareTo(ulp) < 0;
        }
        return x == null && y == null;
    }

    public static <T> boolean eq(T x, T y) {
        return Comparison.equals(x, y);
    }

    public static <T> boolean eq(T[] x, T[] y) {
        return Arrays.deepEquals(x, y);
    }

    public static boolean ne(boolean x, boolean y) {
        return !Comparison.eq(x, y);
    }

    public static boolean ne(int x, int y) {
        return !Comparison.eq(x, y);
    }

    public static boolean ne(long x, long y) {
        return !Comparison.eq(x, y);
    }

    public static boolean ne(float x, float y) {
        return !Comparison.eq(x, y);
    }

    public static boolean ne(double x, double y) {
        return !Comparison.eq(x, y);
    }

    public static boolean ne(Float x, Float y) {
        return !Comparison.eq(x, y);
    }

    public static boolean ne(Double x, Double y) {
        return !Comparison.eq(x, y);
    }

    public static boolean ne(BigDecimal x, BigDecimal y) {
        return !Comparison.eq(x, y);
    }

    public static <T> boolean ne(T x, T y) {
        return !Comparison.eq(x, y);
    }

    public static <T> boolean ne(T[] x, T[] y) {
        return !Comparison.eq(x, y);
    }

    public static boolean gt(boolean x, boolean y) {
        return x && !y;
    }

    public static boolean gt(int x, int y) {
        return x > y;
    }

    public static boolean gt(long x, long y) {
        return x > y;
    }

    public static Boolean gt(float x, float y) {
        if (Float.isNaN(x) || Float.isNaN(y)) {
            return null;
        }
        return x > y && (Float.isInfinite(x) || x - y > Math.ulp(x));
    }

    public static Boolean gt(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return null;
        }
        return x > y && (Double.isInfinite(x) || x - y > Math.ulp(x));
    }

    public static Boolean gt(Float x, Float y) {
        Boolean res = null;
        if (x == y) {
            return false;
        }
        if (x != null && y != null) {
            res = Comparison.gt(x.floatValue(), y.floatValue());
        }
        return res;
    }

    public static Boolean gt(Double x, Double y) {
        Boolean res = null;
        if (x == y) {
            return false;
        }
        if (x != null && y != null) {
            res = Comparison.gt((double)x, (double)y);
        }
        return res;
    }

    public static <T extends Comparable<T>> Boolean gt(T x, T y) {
        return Comparison.greatThan(x, y);
    }

    public static boolean lt(boolean x, boolean y) {
        return Comparison.gt(y, x);
    }

    public static boolean lt(int x, int y) {
        return Comparison.gt(y, x);
    }

    public static boolean lt(long x, long y) {
        return Comparison.gt(y, x);
    }

    public static boolean lt(float x, float y) {
        return Comparison.gt(y, x);
    }

    public static boolean lt(double x, double y) {
        return Comparison.gt(y, x);
    }

    public static Boolean lt(Float x, Float y) {
        return Comparison.gt(y, x);
    }

    public static Boolean lt(Double x, Double y) {
        return Comparison.gt(y, x);
    }

    public static <T extends Comparable<T>> Boolean lt(T x, T y) {
        return Comparison.gt(y, x);
    }

    public static boolean ge(boolean x, boolean y) {
        return x || !y;
    }

    public static boolean ge(int x, int y) {
        return x >= y;
    }

    public static boolean ge(long x, long y) {
        return x >= y;
    }

    public static Boolean ge(float x, float y) {
        if (Comparison.eq(x, y)) {
            return true;
        }
        return Comparison.gt(x, y);
    }

    public static Boolean ge(double x, double y) {
        if (Comparison.eq(x, y)) {
            return true;
        }
        return Comparison.gt(x, y);
    }

    public static Boolean ge(Float x, Float y) {
        Boolean res = null;
        if (x == null && y == null) {
            res = true;
        } else if (x != null && y != null) {
            res = Comparison.ge(x.floatValue(), y.floatValue());
        }
        return res;
    }

    public static Boolean ge(Double x, Double y) {
        Boolean res = null;
        if (x == null && y == null) {
            res = true;
        } else if (x != null && y != null) {
            res = Comparison.ge((double)x, (double)y);
        }
        return res;
    }

    public static <T extends Comparable<T>> Boolean ge(T x, T y) {
        return Comparison.greatOrEquals(x, y);
    }

    public static boolean le(boolean x, boolean y) {
        return Comparison.ge(y, x);
    }

    public static boolean le(int x, int y) {
        return Comparison.ge(y, x);
    }

    public static boolean le(long x, long y) {
        return Comparison.ge(y, x);
    }

    public static boolean le(float x, float y) {
        return Comparison.ge(y, x);
    }

    public static boolean le(double x, double y) {
        return Comparison.ge(y, x);
    }

    public static Boolean le(Float x, Float y) {
        return Comparison.ge(y, x);
    }

    public static Boolean le(Double x, Double y) {
        return Comparison.ge(y, x);
    }

    public static <T extends Comparable<T>> Boolean le(T x, T y) {
        return Comparison.ge(y, x);
    }

    public static boolean strict_eq(float x, float y) {
        return x == y;
    }

    public static boolean strict_eq(double x, double y) {
        return x == y;
    }

    public static boolean strict_eq(Float x, Float y) {
        return Comparison.equals(x, y);
    }

    public static boolean strict_eq(Double x, Double y) {
        return Comparison.equals(x, y);
    }

    public static boolean strict_eq(BigDecimal x, BigDecimal y) {
        return Comparison.equals(x, y);
    }

    public static boolean strict_eq(Object x, Object y) {
        return x == y;
    }

    public static boolean strict_ne(float x, float y) {
        return !Comparison.strict_eq(x, y);
    }

    public static boolean strict_ne(double x, double y) {
        return !Comparison.strict_eq(x, y);
    }

    public static boolean strict_ne(Float x, Float y) {
        return !Comparison.strict_eq(x, y);
    }

    public static boolean strict_ne(Double x, Double y) {
        return !Comparison.strict_eq(x, y);
    }

    public static boolean strict_ne(BigDecimal x, BigDecimal y) {
        return !Comparison.strict_eq(x, y);
    }

    public static boolean strict_ne(Object x, Object y) {
        return !Comparison.strict_eq(x, y);
    }

    public static boolean strict_gt(float x, float y) {
        return x > y;
    }

    public static boolean strict_gt(double x, double y) {
        return x > y;
    }

    public static Boolean strict_gt(Float x, Float y) {
        Boolean res = null;
        if (x != null && y != null) {
            res = x.floatValue() > y.floatValue();
        }
        return res;
    }

    public static Boolean strict_gt(Double x, Double y) {
        Boolean res = null;
        if (x != null && y != null) {
            res = x > y;
        }
        return res;
    }

    public static boolean strict_lt(float x, float y) {
        return Comparison.strict_gt(y, x);
    }

    public static boolean strict_lt(double x, double y) {
        return Comparison.strict_gt(y, x);
    }

    public static Boolean strict_lt(Float x, Float y) {
        return Comparison.strict_gt(y, x);
    }

    public static Boolean strict_lt(Double x, Double y) {
        return Comparison.strict_gt(y, x);
    }

    public static boolean strict_ge(float x, float y) {
        return x >= y;
    }

    public static boolean strict_ge(double x, double y) {
        return x >= y;
    }

    public static Boolean strict_ge(Float x, Float y) {
        Boolean res = null;
        if (x != null && y != null) {
            res = x.floatValue() >= y.floatValue();
        }
        return res;
    }

    public static Boolean strict_ge(Double x, Double y) {
        Boolean res = null;
        if (x != null && y != null) {
            res = x >= y;
        }
        return res;
    }

    public static boolean strict_le(float x, float y) {
        return Comparison.strict_ge(y, x);
    }

    public static boolean strict_le(double x, double y) {
        return Comparison.strict_ge(y, x);
    }

    public static Boolean strict_le(Float x, Float y) {
        return Comparison.strict_ge(y, x);
    }

    public static Boolean strict_le(Double x, Double y) {
        return Comparison.strict_ge(y, x);
    }

    private static <T extends Comparable<T>> Boolean greatOrEquals(T x, T y) {
        Boolean res = null;
        if (x == y) {
            res = true;
        } else if (x != null && y != null) {
            res = x.compareTo(y) >= 0;
        }
        return res;
    }

    private static <T extends Comparable<T>> Boolean greatThan(T x, T y) {
        Boolean res = null;
        if (x == y) {
            return false;
        }
        if (x != null && y != null) {
            res = x.compareTo(y) > 0;
        }
        return res;
    }

    private static <T> boolean equals(T x, T y) {
        return x == y || x != null && y != null && x.equals(y);
    }
}

