/*
 * Decompiled with CFR 0.152.
 */
package org.openl.cache;

public class GenericKey {
    private static final GenericKey NULL_KEY = new GenericKey();

    private GenericKey() {
    }

    public static GenericKey getInstance(Object object1, Object object2) {
        if (object1 == null) {
            if (object2 == null) {
                return NULL_KEY;
            }
            return new Single2Key(object2);
        }
        if (object2 == null) {
            return new Single1Key(object1);
        }
        return new ToupleKey(object1, object2);
    }

    private static class Single2Key
    extends SingleKey {
        Single2Key(Object object) {
            super(object);
        }
    }

    private static class Single1Key
    extends SingleKey {
        Single1Key(Object object) {
            super(object);
        }
    }

    private static class ToupleKey
    extends GenericKey {
        Object object1;
        Object object2;

        ToupleKey(Object object1, Object object2) {
            assert (object1 != null && object2 != null);
            this.object1 = object1;
            this.object2 = object2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToupleKey toupleKey = (ToupleKey)o;
            if (!this.object1.equals(toupleKey.object1)) {
                return false;
            }
            return this.object2.equals(toupleKey.object2);
        }

        public int hashCode() {
            int result = this.object1.hashCode();
            result = 31 * result + this.object2.hashCode();
            return result;
        }
    }

    private static class SingleKey
    extends GenericKey {
        Object object;

        SingleKey(Object object) {
            assert (object != null);
            this.object = object;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleKey singleKey = (SingleKey)o;
            return this.object.equals(singleKey.object);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }
}

