/*
 * Decompiled with CFR 0.152.
 */
package org.openl.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openl.classloader.ClassLoaderUtils;
import org.openl.classloader.OpenLClassLoader;

public abstract class OpenLBundleClassLoader
extends OpenLClassLoader {
    private Set<ClassLoader> bundleClassLoaders = new LinkedHashSet<ClassLoader>();

    OpenLBundleClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Bundle class loader cannot be null");
        }
        if (classLoader == this) {
            throw new IllegalArgumentException("Bundle class loader cannot register himself");
        }
        if (classLoader instanceof OpenLBundleClassLoader && ((OpenLBundleClassLoader)classLoader).containsClassLoader(this)) {
            throw new IllegalArgumentException("Bundle class loader cannot register class loader containing himself");
        }
        this.bundleClassLoaders.add(classLoader);
    }

    protected Set<ClassLoader> getBundleClassLoaders() {
        return Collections.unmodifiableSet(this.bundleClassLoaders);
    }

    public boolean containsClassLoader(ClassLoader classLoader) {
        if (this.bundleClassLoaders.contains(classLoader)) {
            return true;
        }
        for (ClassLoader bundleClassLoader : this.bundleClassLoaders) {
            if (!(bundleClassLoader instanceof OpenLBundleClassLoader) || !((OpenLBundleClassLoader)bundleClassLoader).containsClassLoader(classLoader)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (ClassLoader classLoader : this.bundleClassLoaders) {
            ClassLoaderUtils.close(classLoader);
        }
    }
}

