/*
 * Decompiled with CFR 0.152.
 */
package org.openl.classloader;

import java.net.URL;
import java.util.Set;
import org.openl.classloader.OpenLBundleClassLoader;

public class SimpleBundleClassLoader
extends OpenLBundleClassLoader {
    public SimpleBundleClassLoader(ClassLoader parent) {
        this(new URL[0], parent);
    }

    public SimpleBundleClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.findClassInBundles(name);
        if (clazz != null) {
            return clazz;
        }
        return super.loadClass(name);
    }

    protected Class<?> findClassInBundles(String name) {
        Set<ClassLoader> bundleClassLoaders = this.getBundleClassLoaders();
        for (ClassLoader bundleClassLoader : bundleClassLoaders) {
            try {
                Class<?> clazz = null;
                if (bundleClassLoader instanceof SimpleBundleClassLoader && bundleClassLoader.getParent() == this) {
                    clazz = ((SimpleBundleClassLoader)bundleClassLoader).findLoadedClassInBundle(name);
                    if (clazz == null) {
                        clazz = ((SimpleBundleClassLoader)bundleClassLoader).findClassInBundles(name);
                    }
                } else {
                    clazz = bundleClassLoader.loadClass(name);
                }
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    protected Class<?> findLoadedClassInBundle(String name) {
        return this.findLoadedClass(name);
    }
}

