/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.ClassFactory;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.OpenConfigurationException;
import org.openl.util.RuntimeExceptionWrapper;

public abstract class AGenericConfiguration
extends AConfigurationElement {
    protected String implementingClassName;
    String classResourse;
    String fileResource;
    String urlResource;
    List<StringProperty> properties;
    String classPathResource;

    public void addProperty(StringProperty prop) {
        if (this.properties == null) {
            this.properties = new ArrayList<StringProperty>();
        }
        this.properties.add(prop);
    }

    public Object createResource(IConfigurableResourceContext cxt) {
        try {
            Method m;
            Class<?> implementingClass = ClassFactory.validateClassExistsAndPublic(this.implementingClassName, cxt.getClassLoader(), this.getUri());
            Object res = ClassFactory.newInstance(implementingClass, this.getUri());
            if (this.classResourse != null) {
                Class<?> resourceClass = ClassFactory.validateClassExistsAndPublic(this.classResourse, cxt.getClassLoader(), this.getUri());
                m = ClassFactory.validateHasMethod(implementingClass, "setClassResource", new Class[]{Class.class}, this.getUri());
                m.invoke(res, resourceClass);
            }
            if (this.fileResource != null) {
                File f = new File(this.fileResource);
                m = ClassFactory.validateHasMethod(implementingClass, "setFile", new Class[]{File.class}, this.getUri());
                m.invoke(res, f);
            }
            if (this.urlResource != null) {
                URL url = new URL(this.urlResource);
                m = ClassFactory.validateHasMethod(implementingClass, "setURL", new Class[]{File.class}, this.getUri());
                m.invoke(res, url);
            }
            if (this.properties != null) {
                Method m2 = ClassFactory.validateHasMethod(implementingClass, "setProperty", new Class[]{String.class, String.class}, this.getUri());
                for (StringProperty prop : this.properties) {
                    m2.invoke(res, prop.getName(), prop.getValue());
                }
            }
            return res;
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    public abstract Class<?> getImplementingClass();

    public void setFile(String filename) {
        this.fileResource = filename;
    }

    public void setImplementingClass(String classname) {
        this.implementingClassName = classname;
    }

    public void setResourceClass(String classname) {
        this.classResourse = classname;
    }

    @Override
    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        Class<?> implementingClass = ClassFactory.validateClassExistsAndPublic(this.implementingClassName, cxt.getClassLoader(), this.getUri());
        ClassFactory.validateSuper(implementingClass, this.getImplementingClass(), this.getUri());
        ClassFactory.validateHaveNewInstance(implementingClass, this.getUri());
        if (this.classResourse != null) {
            ClassFactory.validateClassExistsAndPublic(this.classResourse, cxt.getClassLoader(), this.getUri());
            ClassFactory.validateHasMethod(implementingClass, "setClassResource", new Class[]{Class.class}, this.getUri());
        }
        if (this.fileResource != null) {
            if (!new File(this.fileResource).exists()) {
                throw new OpenConfigurationException("File " + this.fileResource + " does not exist", this.getUri(), null);
            }
            ClassFactory.validateHasMethod(implementingClass, "setFile", new Class[]{File.class}, this.getUri());
        }
        if (this.urlResource != null) {
            try {
                new URL(this.urlResource).openConnection();
            }
            catch (Throwable t) {
                throw new OpenConfigurationException("Can not connect to URL " + this.urlResource, this.getUri(), t);
            }
            ClassFactory.validateHasMethod(implementingClass, "setURL", new Class[]{URL.class}, this.getUri());
        }
        if (this.properties != null) {
            ClassFactory.validateHasMethod(implementingClass, "setProperty", new Class[]{String.class, String.class}, this.getUri());
        }
    }

    public static class StringProperty {
        String name;
        String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

