/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Stack;
import org.openl.OpenL;
import org.openl.binding.impl.Binder;
import org.openl.conf.BaseOpenLBuilder;
import org.openl.conf.IOpenLConfiguration;
import org.openl.conf.IUserContext;
import org.openl.conf.NoAntOpenLTask;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.UserContext;
import org.openl.impl.DefaultCompileContext;
import org.openl.syntax.impl.Parser;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.SimpleVM;

public abstract class AOpenLBuilder
extends BaseOpenLBuilder {
    public static UserContextStack userCxt = new UserContextStack();
    boolean inheritExtendedConfigurationLoader = false;

    @Override
    public OpenL build(String openl) throws OpenConfigurationException {
        OpenL op = new OpenL();
        op.setName(openl);
        boolean changedClassLoader = false;
        ClassLoader oldClassLoader = null;
        try {
            userCxt.push(this.getUserEnvironmentContext());
            ClassLoader myClassLoader = this.myClassLoader();
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            if (oldClassLoader != myClassLoader) {
                Thread.currentThread().setContextClassLoader(myClassLoader);
                changedClassLoader = true;
            }
            UserContext mycxt = new UserContext(myClassLoader, this.getUserEnvironmentContext().getUserHome());
            NoAntOpenLTask naot = this.getNoAntOpenLTask();
            naot.setInheritExtendedConfigurationLoader(this.inheritExtendedConfigurationLoader);
            if (this.inheritExtendedConfigurationLoader) {
                naot.execute(this.getUserEnvironmentContext(), this.getUserEnvironmentContext().getUserHome());
            } else {
                naot.execute(mycxt, this.getUserEnvironmentContext().getUserHome());
            }
            IOpenLConfiguration conf = NoAntOpenLTask.retrieveConfiguration();
            op.setParser(new Parser(conf));
            op.setBinder(new Binder(conf, conf, conf, conf, conf, op));
            op.setVm(new SimpleVM());
            op.setCompileContext(new DefaultCompileContext());
            if (changedClassLoader) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            userCxt.pop();
        }
        catch (Exception ex) {
            try {
                throw RuntimeExceptionWrapper.wrap((Throwable)ex);
            }
            catch (Throwable throwable) {
                if (changedClassLoader) {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                userCxt.pop();
                throw throwable;
            }
        }
        return op;
    }

    public abstract NoAntOpenLTask getNoAntOpenLTask();

    protected Properties getProperties(String openl) {
        URL url = this.getResourceContext().findClassPathResource(openl.replace('.', '/') + '/' + openl + ".ant.properties");
        if (url == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = url.openStream();
            Properties p = new Properties();
            p.load(is);
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable t) {
                Log.error((Object)"Error closing stream", (Throwable)t);
            }
        }
    }

    ClassLoader myClassLoader() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        String myName = this.getClass().getName();
        try {
            oldClassLoader.loadClass(myName);
            return oldClassLoader;
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader();
        }
    }

    public void setInheritExtendedConfigurationLoader(boolean inheritExtendedConfigurationLoader) {
        this.inheritExtendedConfigurationLoader = inheritExtendedConfigurationLoader;
    }

    public boolean isInheritExtendedConfigurationLoader() {
        return this.inheritExtendedConfigurationLoader;
    }

    static class UserContextStack
    extends ThreadLocal<Stack<IUserContext>> {
        UserContextStack() {
        }

        @Override
        protected Stack<IUserContext> initialValue() {
            return new Stack<IUserContext>();
        }

        public IUserContext pop() {
            return this.stack().pop();
        }

        public void push(IUserContext ucxt) {
            this.stack().push(ucxt);
        }

        protected Stack<IUserContext> stack() {
            return (Stack)this.get();
        }

        public IUserContext top() {
            return this.stack().peek();
        }
    }
}

