/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.util.ArrayList;
import java.util.LinkedList;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.GenericLibraryConfiguration;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IMethodFactoryConfigurationElement;
import org.openl.conf.JavaLibraryConfiguration;
import org.openl.conf.OpenConfigurationException;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;

public class NameSpacedLibraryConfiguration
extends AConfigurationElement {
    String namespace;
    ArrayList<IMethodFactoryConfigurationElement> factories = new ArrayList();

    public void addAnyLibrary(GenericLibraryConfiguration glb) {
        this.factories.add(glb);
    }

    public void addJavalib(JavaLibraryConfiguration factory) {
        this.factories.add(factory);
    }

    public IOpenField getField(String name, IConfigurableResourceContext cxt, boolean strictMatch) {
        for (IMethodFactoryConfigurationElement factory : this.factories) {
            IOpenField field = factory.getLibrary(cxt).getVar(name, strictMatch);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public IOpenMethod[] getMethods(String name, IConfigurableResourceContext cxt) throws AmbiguousMethodException {
        LinkedList<IOpenMethod> methods = new LinkedList<IOpenMethod>();
        for (IMethodFactoryConfigurationElement factory : this.factories) {
            Iterable<IOpenMethod> itr = factory.getLibrary(cxt).methods(name);
            for (IOpenMethod method : itr) {
                methods.add(method);
            }
        }
        return methods.toArray(new IOpenMethod[0]);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    @Override
    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        for (IMethodFactoryConfigurationElement factory : this.factories) {
            factory.validate(cxt);
        }
    }
}

