/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.util.ArrayList;
import java.util.List;
import org.openl.binding.exception.AmbiguousTypeException;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.ITypeFactoryConfigurationElement;
import org.openl.conf.OpenConfigurationException;
import org.openl.types.IOpenClass;

public class NameSpacedTypeConfiguration
extends AConfigurationElement {
    private String namespace;
    private List<ITypeFactoryConfigurationElement> factories = new ArrayList<ITypeFactoryConfigurationElement>();

    public void addConfiguration(ITypeFactoryConfigurationElement factory) {
        this.factories.add(factory);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public IOpenClass getType(String name, IConfigurableResourceContext cxt) throws AmbiguousTypeException {
        ArrayList<IOpenClass> foundTypes = new ArrayList<IOpenClass>(2);
        for (ITypeFactoryConfigurationElement confElem : this.factories) {
            IOpenClass type = confElem.getLibrary(cxt).getType(name);
            if (type == null) continue;
            foundTypes.add(type);
        }
        switch (foundTypes.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (IOpenClass)foundTypes.get(0);
            }
        }
        throw new AmbiguousTypeException(name, foundTypes);
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    @Override
    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        for (ITypeFactoryConfigurationElement confElem : this.factories) {
            confElem.validate(cxt);
        }
    }
}

