/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import org.openl.conf.ClassFactory;
import org.openl.conf.ClassLoaderFactory;
import org.openl.conf.ConfigurableResourceContext;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IOpenLConfiguration;
import org.openl.conf.IUserContext;
import org.openl.conf.LibraryFactoryConfiguration;
import org.openl.conf.NodeBinderFactoryConfiguration;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.OpenFactoryConfiguration;
import org.openl.conf.OpenLConfiguration;
import org.openl.conf.TypeCastFactory;
import org.openl.conf.TypeFactoryConfiguration;
import org.openl.conf.UserContext;
import org.openl.syntax.grammar.IGrammar;
import org.openl.util.RuntimeExceptionWrapper;

public class NoAntOpenLTask {
    public static IOpenLConfiguration lastConfiguration;
    boolean inheritExtendedConfigurationLoader = false;
    String uri = "java://source_code";
    boolean shared = false;
    OpenLConfiguration conf = new OpenLConfiguration();
    String category;
    String classpath;
    String extendsCategory;

    public static IOpenLConfiguration retrieveConfiguration() {
        if (lastConfiguration == null) {
            throw new NullPointerException();
        }
        IOpenLConfiguration ret = lastConfiguration;
        lastConfiguration = null;
        return ret;
    }

    public void addConfiguredTypeFactory(OpenFactoryConfiguration of) {
        this.conf.addOpenFactory(of);
    }

    public NodeBinderFactoryConfiguration createBindings() {
        NodeBinderFactoryConfiguration nbf = new NodeBinderFactoryConfiguration();
        this.conf.setBinderFactory(nbf);
        return nbf;
    }

    public ClassFactory createGrammar() {
        ClassFactory cf = new ClassFactory();
        cf.setExtendsClassName(IGrammar.class.getName());
        this.conf.setGrammarFactory(cf);
        return cf;
    }

    public LibraryFactoryConfiguration createLibraries() {
        LibraryFactoryConfiguration mf = new LibraryFactoryConfiguration();
        this.conf.setMethodFactory(mf);
        return mf;
    }

    public TypeCastFactory createTypecast() {
        this.conf.createTypeCastFactory();
        return this.conf.getTypeCastFactory();
    }

    public TypeFactoryConfiguration createTypes() {
        TypeFactoryConfiguration mf = new TypeFactoryConfiguration();
        this.conf.setTypeFactory(mf);
        return mf;
    }

    public void execute(IUserContext ucxt, String baseDir) {
        try {
            if (this.category == null) {
                throw new OpenConfigurationException("The category must be set", this.getUri(), null);
            }
            IOpenLConfiguration existing = OpenLConfiguration.getInstance(this.category, ucxt);
            if (existing != null) {
                this.saveConfiguration(existing);
                return;
            }
            IOpenLConfiguration extendsConfiguration = null;
            if (this.extendsCategory != null && (extendsConfiguration = OpenLConfiguration.getInstance(this.extendsCategory, ucxt)) == null) {
                throw new OpenConfigurationException("The extended category " + this.extendsCategory + " must have been loaded first", this.getUri(), null);
            }
            IConfigurableResourceContext cxt = this.getConfigurationContext(extendsConfiguration, ucxt, baseDir);
            this.conf.setParent(extendsConfiguration);
            this.conf.setConfigurationContext(cxt);
            this.conf.validate(cxt);
            OpenLConfiguration.register(this.category, ucxt, this.conf, this.shared);
            this.saveConfiguration(this.conf);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    public String getCategory() {
        return this.category;
    }

    IConfigurableResourceContext getConfigurationContext(IOpenLConfiguration extendsConfiguration, IUserContext ucxt, String baseDir) throws Exception {
        ClassLoader parentLoader;
        ClassLoader myClassLoader = parentLoader = extendsConfiguration == null ? ClassLoaderFactory.getOpenlCoreLoader(null) : extendsConfiguration.getConfigurationContext().getClassLoader();
        if (this.classpath != null && this.classpath.trim().length() != 0) {
            UserContext ucxt2 = new UserContext(null, baseDir);
            myClassLoader = ClassLoaderFactory.createUserClassloader(this.category, this.classpath, parentLoader, ucxt2);
        } else if (!this.inheritExtendedConfigurationLoader) {
            myClassLoader = ucxt.getUserClassLoader();
        }
        return new ConfigurableResourceContext(myClassLoader, this.conf);
    }

    public String getExtendsCategory() {
        return this.extendsCategory;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isInheritExtendedConfigurationLoader() {
        return this.inheritExtendedConfigurationLoader;
    }

    public boolean isShared() {
        return this.shared;
    }

    void saveConfiguration(IOpenLConfiguration conf) {
        lastConfiguration = conf;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setExtendsCategory(String string) {
        this.extendsCategory = string;
    }

    public void setInheritExtendedConfigurationLoader(boolean inheritExtendedConfigurationLoader) {
        this.inheritExtendedConfigurationLoader = inheritExtendedConfigurationLoader;
    }

    public void setShared(boolean b) {
        this.shared = b;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

