/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import org.openl.OpenL;
import org.openl.binding.impl.cast.CastFactory;
import org.openl.conf.AOpenLBuilder;
import org.openl.conf.JavaImportTypeConfiguration;
import org.openl.conf.JavaLibraryConfiguration;
import org.openl.conf.LibraryFactoryConfiguration;
import org.openl.conf.NameSpacedLibraryConfiguration;
import org.openl.conf.NameSpacedTypeConfiguration;
import org.openl.conf.NoAntOpenLTask;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.OperatorsNamespace;
import org.openl.conf.TypeCastFactory;
import org.openl.conf.TypeFactoryConfiguration;

public class OpenLBuilderImpl
extends AOpenLBuilder {
    private String extendsCategory = "org.openl.j";
    private String category;
    private String[] packageImports = new String[0];
    private String[] classImports = new String[0];
    private String[] libraries = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenL build(String category) throws OpenConfigurationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader userEnvitonmentContextClassLoader = this.getUserEnvironmentContext().getUserClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(userEnvitonmentContextClassLoader);
            OpenL.getInstance(this.extendsCategory, this.getUserEnvironmentContext());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return super.build(category);
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public NoAntOpenLTask getNoAntOpenLTask() {
        NoAntOpenLTask op = new NoAntOpenLTask();
        op.setExtendsCategory(this.extendsCategory);
        op.setCategory(this.category);
        if (this.libraries != null && this.libraries.length > 0) {
            LibraryFactoryConfiguration libraries = op.createLibraries();
            NameSpacedLibraryConfiguration thisNamespaceLibrary = new NameSpacedLibraryConfiguration();
            thisNamespaceLibrary.setNamespace("org.openl.this");
            NameSpacedLibraryConfiguration operationNamespaceLibrary = null;
            TypeCastFactory typeCastFactory = op.createTypecast();
            String[] stringArray = this.libraries;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String libraryName = stringArray[i];
                JavaLibraryConfiguration javalib = new JavaLibraryConfiguration();
                javalib.setClassName(libraryName);
                try {
                    Class<?> libraryClass = this.getUserEnvironmentContext().getUserClassLoader().loadClass(libraryName);
                    if (libraryClass.getAnnotation(OperatorsNamespace.class) != null) {
                        if (operationNamespaceLibrary == null) {
                            operationNamespaceLibrary = new NameSpacedLibraryConfiguration();
                            operationNamespaceLibrary.setNamespace("org.openl.operators");
                        }
                        operationNamespaceLibrary.addJavalib(javalib);
                    }
                }
                catch (Exception libraryClass) {
                    // empty catch block
                }
                thisNamespaceLibrary.addJavalib(javalib);
                TypeCastFactory.JavaCastComponent javaCastComponent = new TypeCastFactory.JavaCastComponent(typeCastFactory);
                javaCastComponent.setLibraryClassName(libraryName);
                javaCastComponent.setClassName(CastFactory.class.getName());
                typeCastFactory.addJavaCast(javaCastComponent);
            }
            if (operationNamespaceLibrary != null) {
                libraries.addConfiguredLibrary(operationNamespaceLibrary);
            }
            libraries.addConfiguredLibrary(thisNamespaceLibrary);
        }
        if (this.packageImports != null && this.packageImports.length > 0 || this.classImports != null && this.classImports.length > 0) {
            TypeFactoryConfiguration types = op.createTypes();
            NameSpacedTypeConfiguration typelibrary = new NameSpacedTypeConfiguration();
            typelibrary.setNamespace("org.openl.this");
            JavaImportTypeConfiguration javaImportTypeConfiguration = new JavaImportTypeConfiguration();
            if (this.packageImports != null) {
                for (String packageName : this.packageImports) {
                    javaImportTypeConfiguration.addPackageImport(packageName);
                }
            }
            if (this.classImports != null) {
                for (String classeName : this.classImports) {
                    javaImportTypeConfiguration.addClassImport(classeName);
                }
            }
            typelibrary.addConfiguration(javaImportTypeConfiguration);
            types.addConfiguredTypeLibrary(typelibrary);
        }
        return op;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setExtendsCategory(String extendsCategory) {
        this.extendsCategory = extendsCategory;
    }

    public void setClassImports(String[] classImports) {
        this.classImports = classImports;
    }

    public void setLibraries(String[] libraries) {
        this.libraries = libraries;
    }

    public void setPackageImports(String[] packageImports) {
        this.packageImports = packageImports;
    }
}

