/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openl.binding.ICastFactory;
import org.openl.binding.INodeBinder;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.impl.cast.CastFactory;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.method.MethodSearch;
import org.openl.cache.GenericKey;
import org.openl.conf.ClassFactory;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IOpenFactoryConfiguration;
import org.openl.conf.IOpenLConfiguration;
import org.openl.conf.IUserContext;
import org.openl.conf.LibraryFactoryConfiguration;
import org.openl.conf.NodeBinderFactoryConfiguration;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.OpenFactoryConfiguration;
import org.openl.conf.TypeCastFactory;
import org.openl.conf.TypeFactoryConfiguration;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.grammar.IGrammar;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenFactory;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodKey;

public class OpenLConfiguration
implements IOpenLConfiguration {
    private static HashMap<Object, IOpenLConfiguration> configurations = new HashMap();
    private String uri;
    private IOpenLConfiguration parent;
    private IConfigurableResourceContext configurationContext;
    private ClassFactory grammarFactory;
    private NodeBinderFactoryConfiguration binderFactory;
    private LibraryFactoryConfiguration methodFactory;
    private TypeCastFactory typeCastFactory;
    private TypeFactoryConfiguration typeFactory;
    private Map<String, IOpenFactoryConfiguration> openFactories = null;
    Map<String, Map<String, IOpenClass>> cache = new HashMap<String, Map<String, IOpenClass>>();

    public static IOpenLConfiguration getInstance(String name, IUserContext ucxt) throws OpenConfigurationException {
        IOpenLConfiguration opc = configurations.get(name);
        if (opc != null) {
            return opc;
        }
        GenericKey key = GenericKey.getInstance(name, ucxt);
        return configurations.get(key);
    }

    public static synchronized void register(String name, IUserContext ucxt, IOpenLConfiguration oplc, boolean shared) throws OpenConfigurationException {
        Object key = shared ? name : GenericKey.getInstance(name, ucxt);
        IOpenLConfiguration old = configurations.get(key);
        if (old != null) {
            throw new OpenConfigurationException("The configuration " + name + " already exists", null, null);
        }
        configurations.put(key, oplc);
    }

    public static void reset() {
        configurations = new HashMap();
    }

    public static synchronized void unregister(String name, IUserContext ucxt) throws OpenConfigurationException {
        GenericKey key = GenericKey.getInstance(name, ucxt);
        configurations.remove(key);
        configurations.remove(name);
    }

    @Override
    public synchronized void addOpenFactory(IOpenFactoryConfiguration opfc) throws OpenConfigurationException {
        if (this.openFactories == null) {
            this.openFactories = new HashMap<String, IOpenFactoryConfiguration>();
        }
        if (opfc.getName() == null) {
            throw new OpenConfigurationException("The factory must have a name", opfc.getUri(), null);
        }
        if (this.openFactories.containsKey(opfc.getName())) {
            throw new OpenConfigurationException("Duplicated name: " + opfc.getName(), opfc.getUri(), null);
        }
        this.openFactories.put(opfc.getName(), opfc);
    }

    public NodeBinderFactoryConfiguration getBinderFactory() {
        return this.binderFactory;
    }

    @Override
    public IOpenCast getCast(IOpenClass from, IOpenClass to) {
        IOpenCast cast;
        IOpenCast iOpenCast = cast = this.typeCastFactory == null ? null : this.typeCastFactory.getCast(from, to, this.configurationContext);
        if (cast != null) {
            return cast;
        }
        return this.parent == null ? null : this.parent.getCast(from, to);
    }

    protected Collection<TypeCastFactory.JavaCastComponent> getAllJavaCastComponents() {
        ArrayList<TypeCastFactory.JavaCastComponent> javaCastComponents = new ArrayList<TypeCastFactory.JavaCastComponent>();
        if (this.typeCastFactory != null) {
            javaCastComponents.addAll(this.typeCastFactory.getJavaCastComponents());
        }
        if (this.parent != null && this.parent instanceof OpenLConfiguration) {
            javaCastComponents.addAll(((OpenLConfiguration)this.parent).getAllJavaCastComponents());
        }
        return javaCastComponents;
    }

    @Override
    public IOpenClass findClosestClass(IOpenClass openClass1, IOpenClass openClass2) {
        Collection<TypeCastFactory.JavaCastComponent> components = this.getAllJavaCastComponents();
        ArrayList<IOpenMethod> allMethods = new ArrayList<IOpenMethod>();
        for (TypeCastFactory.JavaCastComponent component : components) {
            CastFactory castFactory = component.getCastFactory(this.configurationContext);
            Iterable<IOpenMethod> methods = castFactory.getMethodFactory().methods("autocast");
            for (IOpenMethod method : methods) {
                allMethods.add(method);
            }
        }
        return CastFactory.findClosestClass(openClass1, openClass2, new ICastFactory(){

            @Override
            public IOpenClass findClosestClass(IOpenClass openClass1, IOpenClass openClass2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IOpenCast getCast(IOpenClass from, IOpenClass to) {
                return OpenLConfiguration.this.getCast(from, to);
            }
        }, allMethods);
    }

    @Override
    public IConfigurableResourceContext getConfigurationContext() {
        return this.configurationContext;
    }

    @Override
    public synchronized IGrammar getGrammar() throws OpenConfigurationException {
        if (this.grammarFactory == null) {
            return this.parent.getGrammar();
        }
        return (IGrammar)this.grammarFactory.getResource(this.configurationContext);
    }

    public ClassFactory getGrammarFactory() {
        return this.grammarFactory;
    }

    @Override
    public IMethodCaller getMethodCaller(String namespace, String name, IOpenClass[] params, ICastFactory casts) throws AmbiguousMethodException {
        IOpenMethod[] mcs = this.getMethods(namespace, name);
        return MethodSearch.findMethod(name, params, casts, Arrays.asList(mcs));
    }

    @Override
    public IOpenMethod[] getMethods(String namespace, String name) {
        IOpenMethod[] mcs = this.methodFactory == null ? new IOpenMethod[]{} : this.methodFactory.getMethods(namespace, name, this.configurationContext);
        IOpenMethod[] pmcs = this.parent == null ? new IOpenMethod[]{} : this.parent.getMethods(namespace, name);
        HashMap<MethodKey, ArrayList<IOpenMethod>> methods = new HashMap<MethodKey, ArrayList<IOpenMethod>>();
        for (IOpenMethod method : pmcs) {
            MethodKey mk = new MethodKey(method);
            ArrayList<IOpenMethod> callers = (ArrayList<IOpenMethod>)methods.get(mk);
            if (callers == null) {
                callers = new ArrayList<IOpenMethod>();
                methods.put(mk, callers);
            }
            callers.add(method);
        }
        HashSet<MethodKey> usedKeys = new HashSet<MethodKey>();
        for (IOpenMethod method : mcs) {
            MethodKey mk = new MethodKey(method);
            ArrayList<IOpenMethod> callers = (ArrayList<IOpenMethod>)methods.get(mk);
            if (callers == null) {
                usedKeys.add(mk);
                callers = new ArrayList<IOpenMethod>();
                methods.put(mk, callers);
            }
            if (!usedKeys.contains(mk)) {
                usedKeys.add(mk);
                callers = new ArrayList();
                methods.put(mk, callers);
            }
            callers.add(method);
        }
        ArrayList openMethods = new ArrayList();
        for (Collection m : methods.values()) {
            openMethods.addAll(m);
        }
        return openMethods.toArray(new IOpenMethod[0]);
    }

    public LibraryFactoryConfiguration getMethodFactory() {
        return this.methodFactory;
    }

    @Override
    public INodeBinder getNodeBinder(ISyntaxNode node) {
        INodeBinder binder;
        INodeBinder iNodeBinder = binder = this.binderFactory == null ? null : this.binderFactory.getNodeBinder(node, this.configurationContext);
        if (binder != null) {
            return binder;
        }
        return this.parent == null ? null : this.parent.getNodeBinder(node);
    }

    @Override
    public IOpenFactory getOpenFactory(String name) {
        OpenFactoryConfiguration conf;
        OpenFactoryConfiguration openFactoryConfiguration = conf = this.openFactories == null ? null : (OpenFactoryConfiguration)this.openFactories.get(name);
        if (conf != null) {
            return conf.getOpenFactory(this.configurationContext);
        }
        if (this.parent != null) {
            return this.parent.getOpenFactory(name);
        }
        return null;
    }

    @Override
    public IOpenClass getType(String namespace, String name) {
        IOpenClass type;
        Map<String, IOpenClass> namespaceCache = this.cache.get(namespace);
        if (namespaceCache == null) {
            namespaceCache = new HashMap<String, IOpenClass>();
            this.cache.put(namespace, namespaceCache);
        }
        if (namespaceCache.containsKey(name)) {
            return namespaceCache.get(name);
        }
        IOpenClass iOpenClass = type = this.typeFactory == null ? null : this.typeFactory.getType(namespace, name, this.configurationContext);
        if (type != null) {
            namespaceCache.put(name, type);
            return type;
        }
        if (this.parent == null) {
            namespaceCache.put(name, null);
            return null;
        }
        type = this.parent.getType(namespace, name);
        namespaceCache.put(name, type);
        return type;
    }

    public TypeCastFactory getTypeCastFactory() {
        return this.typeCastFactory;
    }

    public TypeCastFactory createTypeCastFactory() {
        this.typeCastFactory = new TypeCastFactory(this);
        return this.typeCastFactory;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public IOpenField getVar(String namespace, String name, boolean strictMatch) {
        IOpenField field;
        IOpenField iOpenField = field = this.methodFactory == null ? null : this.methodFactory.getVar(namespace, name, this.configurationContext, strictMatch);
        if (field != null) {
            return field;
        }
        return this.parent == null ? null : this.parent.getVar(namespace, name, strictMatch);
    }

    public void setBinderFactory(NodeBinderFactoryConfiguration factory) {
        this.binderFactory = factory;
    }

    public void setConfigurationContext(IConfigurableResourceContext context) {
        this.configurationContext = context;
    }

    public void setGrammarFactory(ClassFactory factory) {
        this.grammarFactory = factory;
    }

    public void setMethodFactory(LibraryFactoryConfiguration factory) {
        this.methodFactory = factory;
    }

    public void setParent(IOpenLConfiguration configuration) {
        this.parent = configuration;
    }

    public void setTypeCastFactory(TypeCastFactory factory) {
        this.typeCastFactory = factory;
    }

    public void setTypeFactory(TypeFactoryConfiguration configuration) {
        this.typeFactory = configuration;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public synchronized void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        if (this.grammarFactory != null) {
            this.grammarFactory.validate(cxt);
        } else if (this.parent == null) {
            throw new OpenConfigurationException("Grammar class is not set", this.getUri(), null);
        }
        if (this.binderFactory != null) {
            this.binderFactory.validate(cxt);
        } else if (this.parent == null) {
            throw new OpenConfigurationException("Bindings are not set", this.getUri(), null);
        }
        if (this.methodFactory != null) {
            this.methodFactory.validate(cxt);
        }
        if (this.typeCastFactory != null) {
            this.typeCastFactory.validate(cxt);
        }
        if (this.typeFactory != null) {
            this.typeFactory.validate(cxt);
        }
        if (this.openFactories != null) {
            for (IOpenFactoryConfiguration factory : this.openFactories.values()) {
                factory.validate(cxt);
            }
        }
    }
}

