/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.io.File;
import java.util.Properties;
import org.openl.conf.ClassFactory;
import org.openl.conf.ClassLoaderFactory;
import org.openl.conf.ConfigurableResourceContext;
import org.openl.conf.Configurator;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IOpenLBuilder;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.PropertyFileLoader;
import org.openl.util.Log;

public class OpenLConfigurator
extends Configurator {
    public static final String OPENL_ALT_CONFIG_ROOT = "lang.config";
    public static final String OPENL_DEFAULT_PROPERTY_FILE_NAME = "OpenL.properties";
    public static final String OPENL_PROPERTY_FILE_PROPERTY = "properties.file";
    public static final String DEFAULT_BUILDER_CLASS_PROPERTY = "org.openl.builderclass";
    public static final String BUILDER_CLASS = ".builderclass";
    public static final String DEFAULT_BUILDER_CLASS_PATH_PROPERTY = "org.openl.builder.classpath";
    public static final String BUILDER_CLASS_PATH = ".builder.classpath";
    public static final String OPENL_BUILDER = "OpenLBuilder";

    public synchronized IOpenLBuilder getBuilder(String openlName, IUserContext ucxt) throws OpenConfigurationException {
        String[] stringArray;
        String userHome = ucxt.getUserHome();
        String altHome = this.makeAlternativeHome(userHome);
        if (altHome == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = userHome;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = userHome;
            stringArray = stringArray3;
            stringArray3[1] = altHome;
        }
        String[] homes = stringArray;
        ConfigurableResourceContext cxt = new ConfigurableResourceContext(ucxt.getUserClassLoader(), homes);
        PropertyFileLoader propertyLoader = new PropertyFileLoader(openlName + "." + OPENL_DEFAULT_PROPERTY_FILE_NAME, openlName + "." + OPENL_PROPERTY_FILE_PROPERTY, cxt, new PropertyFileLoader(OPENL_DEFAULT_PROPERTY_FILE_NAME, "org.openl.properties.file", cxt, null));
        Properties pp = propertyLoader.getProperties();
        cxt.setProperties(pp);
        try {
            IOpenLBuilder builder = this.makeBuilder(openlName, cxt, ucxt);
            builder.setContexts(cxt, ucxt);
            return builder;
        }
        catch (Exception ex) {
            throw new OpenConfigurationException("Error creating builder: ", null, ex);
        }
    }

    String getBuilderClassName(String openl, IConfigurableResourceContext cxt) {
        String builderClassName = cxt.findProperty(openl + BUILDER_CLASS);
        if (builderClassName == null) {
            builderClassName = cxt.findProperty(DEFAULT_BUILDER_CLASS_PROPERTY);
        }
        return builderClassName;
    }

    String getBuilderClassPath(String openl, IConfigurableResourceContext cxt) {
        String builderClassPath = cxt.findProperty(openl + BUILDER_CLASS_PATH);
        if (builderClassPath == null) {
            builderClassPath = cxt.findProperty(DEFAULT_BUILDER_CLASS_PATH_PROPERTY);
        }
        return builderClassPath;
    }

    public String makeAlternativeHome(String userHome) {
        try {
            return new File(userHome + "/../" + OPENL_ALT_CONFIG_ROOT).getCanonicalPath();
        }
        catch (Throwable t) {
            return null;
        }
    }

    IOpenLBuilder makeBuilder(String openl, IConfigurableResourceContext cxt, IUserContext ucxt) throws Exception {
        String builderClassName = this.getBuilderClassName(openl, cxt);
        String builderClassPath = this.getBuilderClassPath(openl, cxt);
        if (builderClassName != null) {
            return this.makeBuilderInstance(builderClassName, builderClassPath, ucxt);
        }
        try {
            builderClassName = openl + "." + OPENL_BUILDER;
            IOpenLBuilder bb = this.makeBuilderInstance(builderClassName, builderClassPath, ucxt);
            return bb;
        }
        catch (Exception e) {
            Log.error((Object)("Can not build " + openl + " using cp: " + builderClassPath + " UCXT: " + ucxt), (Throwable)e);
            throw e;
        }
    }

    IOpenLBuilder makeBuilderInstance(String builderClassName, String builderClassPath, IUserContext ucxt) throws Exception {
        ClassLoader cl = ClassLoaderFactory.getOpenlCoreLoader(ucxt.getUserClassLoader());
        if (builderClassPath != null) {
            cl = ClassLoaderFactory.createUserClassloader("builder.classloader:", builderClassPath, ClassLoaderFactory.getOpenlCoreLoader(ucxt.getUserClassLoader()), ucxt);
        }
        return (IOpenLBuilder)ClassFactory.newInstanceForName(builderClassName, cl);
    }
}

