/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.util.Log;

public class PropertyFileLoader {
    public static final Properties NO_PROPERTIES = new Properties();
    private String propertiesFileDefaultName;
    private String propertiesFileProperty;
    private Properties properties = null;
    private IConfigurableResourceContext context;
    private PropertyFileLoader parent = null;

    public PropertyFileLoader(String propertiesFileDefaultName, String propertiesFileProperty, IConfigurableResourceContext context, PropertyFileLoader parent) {
        this.context = context;
        this.propertiesFileDefaultName = propertiesFileDefaultName;
        this.propertiesFileProperty = propertiesFileProperty;
        this.parent = parent;
    }

    protected IConfigurableResourceContext getContext() {
        return this.context;
    }

    Properties getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        String propertiesFileName = this.getContext().findProperty(this.propertiesFileProperty);
        if (propertiesFileName == null) {
            propertiesFileName = this.propertiesFileDefaultName;
        }
        Log.debug((Object)("Looking for " + propertiesFileName));
        if (!(this.loadAsURL(propertiesFileName) || this.loadAsResource(propertiesFileName) || this.loadAsFile(propertiesFileName))) {
            this.properties = this.parent == null ? NO_PROPERTIES : this.parent.getProperties();
        }
        return this.properties;
    }

    public String getProperty(String propertyName) {
        String res = this.getProperties().getProperty(propertyName);
        if (res != null) {
            return res;
        }
        res = this.getContext().findProperty(propertyName);
        if (res != null) {
            return res;
        }
        return this.parent == null ? null : this.parent.getProperty(propertyName);
    }

    boolean loadAsFile(String url) {
        try {
            File f = this.getContext().findFileSystemResource(url);
            if (f == null) {
                return false;
            }
            FileInputStream in = new FileInputStream(f);
            this.properties = new Properties();
            this.properties.load(in);
            ((InputStream)in).close();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    boolean loadAsResource(String name) {
        try {
            URL url = this.getContext().findClassPathResource(name);
            if (url == null) {
                return false;
            }
            InputStream in = url.openStream();
            Properties p = new Properties();
            p.load(in);
            this.properties = p;
            in.close();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    boolean loadAsURL(String url) {
        try {
            InputStream in = new URL(url).openStream();
            this.properties = new Properties();
            this.properties.load(in);
            in.close();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

