/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openl.binding.impl.StaticClassLibrary;
import org.openl.binding.impl.cast.CastFactory;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.ClassFactory;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IConfigurationElement;
import org.openl.conf.IOpenLConfiguration;
import org.openl.conf.OpenConfigurationException;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class TypeCastFactory
extends AConfigurationElement
implements IConfigurationElement {
    private IOpenLConfiguration configuration;
    private List<JavaCastComponent> components = new ArrayList<JavaCastComponent>();

    TypeCastFactory(IOpenLConfiguration configuration) {
        this.configuration = configuration;
    }

    public void addJavaCast(JavaCastComponent cmp) {
        this.components.add(cmp);
    }

    public Collection<JavaCastComponent> getJavaCastComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public IOpenCast getCast(IOpenClass from, IOpenClass to, IConfigurableResourceContext cxt) {
        for (JavaCastComponent component : this.components) {
            IOpenCast openCast = component.getCastFactory(cxt).getCast(from, to);
            if (openCast == null) continue;
            return openCast;
        }
        return null;
    }

    @Override
    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        for (JavaCastComponent component : this.components) {
            component.validate(cxt);
        }
    }

    public class JavaCastComponent
    extends AConfigurationElement {
        String libraryClassName;
        String className;
        CastFactory factory = null;

        public synchronized CastFactory getCastFactory(IConfigurableResourceContext cxt) {
            if (this.factory == null) {
                Class<?> libClass = ClassFactory.validateClassExistsAndPublic(this.libraryClassName, cxt.getClassLoader(), this.getUri());
                Class<?> implClass = ClassFactory.validateClassExistsAndPublic(this.className, cxt.getClassLoader(), this.getUri());
                this.factory = (CastFactory)ClassFactory.newInstance(implClass, this.getUri());
                this.factory.setMethodFactory(new StaticClassLibrary(JavaOpenClass.getOpenClass(libClass)));
                this.factory.setGlobalCastFactory(TypeCastFactory.this.configuration);
            }
            return this.factory;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public void setLibraryClassName(String string) {
            this.libraryClassName = string;
        }

        @Override
        public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
            ClassFactory.validateClassExistsAndPublic(this.libraryClassName, cxt.getClassLoader(), this.getUri());
            Class<?> implClass = ClassFactory.validateClassExistsAndPublic(this.className, cxt.getClassLoader(), this.getUri());
            ClassFactory.validateSuper(implClass, CastFactory.class, this.getUri());
            ClassFactory.validateHaveNewInstance(implClass, this.getUri());
        }
    }
}

