/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.openl.conf.AUserContext;

public final class UserContext
extends AUserContext {
    private ClassLoader userClassLoader;
    private String userHome;

    public UserContext(ClassLoader userClassLoader, String userHome) {
        this.userClassLoader = userClassLoader;
        this.userHome = new File(userHome).getAbsolutePath();
    }

    @Override
    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    @Override
    public String getUserHome() {
        return this.userHome;
    }

    private String printClassloader(ClassLoader ucl) {
        if (ucl == null) {
            return "null";
        }
        if (ucl instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)ucl).getURLs();
            StringBuilder sb = new StringBuilder();
            sb.append("ClassLoader URLs: ");
            for (URL url : urls) {
                sb.append(url.toExternalForm());
                sb.append(',');
            }
            return sb.toString();
        }
        return ucl.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("home=").append(this.userHome).append("cl=").append(this.printClassloader(this.userClassLoader));
        return sb.toString();
    }
}

