/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IBoundCode;
import org.openl.classloader.OpenLBundleClassLoader;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.IDependencyManager;
import org.openl.engine.ExtendableModuleOpenClass;
import org.openl.engine.FullClassnameSupport;
import org.openl.engine.OpenLBindManager;
import org.openl.engine.OpenLHolder;
import org.openl.engine.OpenLParseManager;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessages;
import org.openl.message.OpenLMessagesUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.SourceType;
import org.openl.syntax.code.Dependency;
import org.openl.syntax.code.IDependency;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.ProcessedCode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.util.CollectionUtils;

public class OpenLSourceManager
extends OpenLHolder {
    public static final String EXTERNAL_DEPENDENCIES_KEY = "external-dependencies";
    public static final String ADDITIONAL_WARN_MESSAGES_KEY = "additional-warn-messages";
    public static final String ADDITIONAL_ERROR_MESSAGES_KEY = "additional-error-messages";
    private OpenLParseManager parseManager;
    private OpenLBindManager bindManager;

    public OpenLSourceManager(OpenL openl) {
        super(openl);
        this.bindManager = new OpenLBindManager(openl);
        this.parseManager = new OpenLParseManager(openl);
    }

    public ProcessedCode processSource(IOpenSourceCodeModule source, SourceType sourceType) {
        return this.processSource(source, sourceType, null, false, null);
    }

    public ProcessedCode processSource(IOpenSourceCodeModule source, SourceType sourceType, IDependencyManager dependencyManager) {
        return this.processSource(source, sourceType, null, false, dependencyManager);
    }

    private Collection<IDependency> getDependencies(IDependencyManager dependencyManager, IDependency[] dependencies) {
        Collection<String> dependencyNames;
        LinkedHashSet<IDependency> result = new LinkedHashSet<IDependency>();
        if (dependencyManager == null) {
            result.addAll(Arrays.asList(dependencies));
            return result;
        }
        try {
            dependencyNames = dependencyManager.getAllDependencies();
            if (dependencyNames == null) {
                result.addAll(Arrays.asList(dependencies));
                return result;
            }
        }
        catch (Exception e) {
            return Arrays.asList(dependencies);
        }
        for (IDependency dependency : dependencies) {
            String value = dependency.getNode().getIdentifier();
            value = value.replaceAll("\\*", "\\\\E.*\\\\Q");
            value = value.replaceAll("\\?", "\\\\E.\\\\Q");
            value = "\\Q" + value + "\\E";
            boolean found = false;
            for (String dependencyName : dependencyNames) {
                if (!Pattern.matches(value, dependencyName)) continue;
                found = true;
                result.add(new Dependency(dependency.getType(), new IdentifierNode(dependency.getNode().getType(), null, dependencyName, null)));
            }
            if (found) continue;
            result.add(dependency);
        }
        return result;
    }

    public ProcessedCode processSource(IOpenSourceCodeModule source, SourceType sourceType, IBindingContextDelegator bindingContextDelegator, boolean ignoreErrors, IDependencyManager dependencyManager) {
        Map<String, Object> externalParams;
        IParsedCode parsedCode = this.parseManager.parseSource(source, sourceType);
        SyntaxNodeException[] parsingErrors = parsedCode.getErrors();
        if (!ignoreErrors && parsingErrors.length > 0) {
            throw new CompositeSyntaxNodeException("Parsing Error:", parsingErrors);
        }
        if (SourceType.MODULE.equals((Object)sourceType)) {
            LinkedHashSet<CompiledDependency> compiledDependencies = new LinkedHashSet<CompiledDependency>();
            List<IDependency> externalDependencies = this.getExternalDependencies(source);
            Iterator dependencies = this.getDependencies(dependencyManager, parsedCode.getDependencies());
            if (CollectionUtils.isNotEmpty(externalDependencies)) {
                dependencies.addAll(externalDependencies);
            }
            ArrayList<OpenLMessage> messages = new ArrayList<OpenLMessage>(OpenLMessages.getCurrentInstance().getMessages());
            ArrayList<OpenLMessage> dependencyMessages = new ArrayList<OpenLMessage>();
            if (CollectionUtils.isNotEmpty(dependencies)) {
                if (dependencyManager != null) {
                    Iterator iterator = dependencies.iterator();
                    while (iterator.hasNext()) {
                        IDependency dependency = (IDependency)iterator.next();
                        try {
                            CompiledDependency loadedDependency = dependencyManager.loadDependency(dependency);
                            this.validateDependency(loadedDependency);
                            OpenLBundleClassLoader currentClassLoader = (OpenLBundleClassLoader)Thread.currentThread().getContextClassLoader();
                            if (loadedDependency.getClassLoader() != currentClassLoader) {
                                currentClassLoader.addClassLoader(loadedDependency.getClassLoader());
                            }
                            compiledDependencies.add(loadedDependency);
                            CompiledOpenClass compiledOpenClass = loadedDependency.getCompiledOpenClass();
                            IOpenClass openClass = compiledOpenClass.getOpenClassWithErrors();
                            if (openClass instanceof ExtendableModuleOpenClass) {
                                ExtendableModuleOpenClass extendableModuleOpenClass = (ExtendableModuleOpenClass)((Object)openClass);
                                extendableModuleOpenClass.applyToDependentParsedCode(parsedCode);
                            }
                            for (OpenLMessage message : compiledOpenClass.getMessages()) {
                                if (dependencyMessages.contains(message)) continue;
                                dependencyMessages.add(message);
                            }
                            OpenLMessages.getCurrentInstance().clear();
                        }
                        catch (Exception e) {
                            messages.addAll(OpenLMessagesUtils.newMessages(e));
                        }
                    }
                    OpenLMessages.getCurrentInstance().addMessages(messages);
                } else {
                    OpenLMessagesUtils.addError("Can't load dependencies. Dependency manager is not defined.");
                }
            }
            parsedCode.setCompiledDependencies(compiledDependencies);
            parsedCode.setMessagesFromDependencies(dependencyMessages);
        }
        if ((externalParams = source.getParams()) != null) {
            Set warnMessages;
            parsedCode.setExternalParams(externalParams);
            if (externalParams.containsKey(ADDITIONAL_WARN_MESSAGES_KEY)) {
                warnMessages = (Set)externalParams.get(ADDITIONAL_WARN_MESSAGES_KEY);
                for (String warnMessage : warnMessages) {
                    OpenLMessagesUtils.addWarn(warnMessage);
                }
            }
            if (externalParams.containsKey(ADDITIONAL_ERROR_MESSAGES_KEY)) {
                warnMessages = (Set)externalParams.get(ADDITIONAL_ERROR_MESSAGES_KEY);
                for (String warnMessage : warnMessages) {
                    OpenLMessagesUtils.addError(warnMessage);
                }
            }
        }
        FullClassnameSupport.transformIdentifierBindersWithBindingContextInfo(bindingContextDelegator, parsedCode);
        IBoundCode boundCode = this.bindManager.bindCode(bindingContextDelegator, parsedCode);
        SyntaxNodeException[] bindingErrors = boundCode.getErrors();
        if (!ignoreErrors && bindingErrors.length > 0) {
            throw new CompositeSyntaxNodeException("Binding Error:", bindingErrors);
        }
        ProcessedCode processedCode = new ProcessedCode();
        processedCode.setParsedCode(parsedCode);
        processedCode.setBoundCode(boundCode);
        return processedCode;
    }

    private void validateDependency(CompiledDependency compiledDependency) {
        if (compiledDependency.getCompiledOpenClass().hasErrors()) {
            String message = String.format("Dependency module %s has critical errors", compiledDependency.getDependencyName());
            OpenLMessagesUtils.addError(message);
        }
    }

    private List<IDependency> getExternalDependencies(IOpenSourceCodeModule source) {
        List dependencies = null;
        Map<String, Object> params = source.getParams();
        if (params != null) {
            dependencies = (List)params.get(EXTERNAL_DEPENDENCIES_KEY);
        }
        return dependencies;
    }
}

