/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openl.ICompileContext;
import org.openl.OpenL;
import org.openl.engine.OpenLHolder;
import org.openl.types.IOpenClass;
import org.openl.validation.IOpenLValidator;
import org.openl.validation.ValidationResult;

public class OpenLValidationManager
extends OpenLHolder {
    private static ThreadLocal<Boolean> validationEnabled = new ThreadLocal();

    public static boolean isValidationEnabled() {
        Boolean validationIsOn = validationEnabled.get();
        return validationIsOn == null || validationIsOn != false;
    }

    public static void turnOffValidation() {
        validationEnabled.set(Boolean.FALSE);
    }

    public static void turnOnValidation() {
        validationEnabled.remove();
    }

    public OpenLValidationManager(OpenL openl) {
        super(openl);
    }

    public List<ValidationResult> validate(IOpenClass openClass) {
        if (OpenLValidationManager.isValidationEnabled()) {
            ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
            ICompileContext context = this.getOpenL().getCompileContext();
            if (context != null) {
                Set<IOpenLValidator> validators = context.getValidators();
                for (IOpenLValidator validator : validators) {
                    ValidationResult result = validator.validate(this.getOpenL(), openClass);
                    results.add(result);
                }
            }
            return results;
        }
        return Collections.emptyList();
    }
}

