/*
 * Decompiled with CFR 0.152.
 */
package org.openl.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.exception.OpenLException;
import org.openl.exception.OpenLExceptionUtils;
import org.openl.main.SourceCodeURLTool;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.util.text.ILocation;

public class OpenLCompilationException
extends Exception
implements OpenLException {
    private static final long serialVersionUID = -8075090606797764194L;
    private Throwable insideCause;
    private ILocation location;
    private IOpenSourceCodeModule source;

    public OpenLCompilationException(String message, Throwable insideCause, ILocation location, IOpenSourceCodeModule source) {
        super(message);
        this.insideCause = insideCause;
        this.location = location;
        this.source = source;
    }

    public OpenLCompilationException(String message, Throwable cause, ILocation location) {
        this(message, cause, location, null);
    }

    public OpenLCompilationException(String message, Throwable cause) {
        this(message, cause, null, null);
    }

    public OpenLCompilationException(String message) {
        this(message, null, null, null);
    }

    public Throwable getOriginalCause() {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)this.insideCause);
        if (rootCause != null) {
            return rootCause;
        }
        return this.insideCause;
    }

    @Override
    public ILocation getLocation() {
        return this.location;
    }

    @Override
    public IOpenSourceCodeModule getSourceModule() {
        return this.source;
    }

    @Override
    public Throwable getCause() {
        return this.getOriginalCause();
    }

    public String getSourceLocation() {
        return SourceCodeURLTool.makeSourceLocationURL(this.getLocation(), this.getSourceModule());
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        OpenLExceptionUtils.printError(this, printWriter);
        SourceCodeURLTool.printSourceLocation(this, printWriter);
        printWriter.close();
        return stringWriter.toString();
    }
}

