/*
 * Decompiled with CFR 0.152.
 */
package org.openl.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.openl.util.FileTool;
import org.openl.util.Log;
import org.openl.util.StringTool;

public class OpenLProjectPropertiesLoader {
    public static final String OPENL_PROPERTIES_FNAME = "openl.project.classpath.properties";
    public static final String OPENL_CLASSPATH_PROPERTY = "openl.project.classpath";
    public static final String OPENL_CLASSPATH_SEPARATOR_PROPERTY = "openl.project.classpath.separator";
    public static final String DISPLAY_NAME_SUFFIX = ".display.name";

    public static String getOpenLPropertiesFolder(String projectHome) {
        return projectHome + "/build";
    }

    private static boolean isTheSame(String ecp, String[] cp) {
        String[] ecps = StringTool.tokenize((String)ecp, (String)File.pathSeparator);
        if (ecps.length != cp.length) {
            return false;
        }
        for (int i = 0; i < ecps.length; ++i) {
            boolean found = false;
            for (int j = 0; j < cp.length; ++j) {
                if (!cp[j].equals(ecps[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        Object[] x = OpenLProjectPropertiesLoader.makeClasspath(".", System.getProperty("java.class.path"), ".*apache.ant.*|.*apache.commons.*|.*apache.tomcat.*|.*javacc.*");
        Arrays.sort(x);
        for (int i = 0; i < x.length; ++i) {
            System.out.println((String)x[i]);
        }
    }

    public static String[] makeClasspath(String phome, String longPath, String excludeFilter) throws IOException {
        ArrayList<String> v = new ArrayList<String>();
        String[] ecps = StringTool.tokenize((String)longPath, (String)File.pathSeparator);
        for (int i = 0; i < ecps.length; ++i) {
            if (excludeFilter != null && ecps[i].matches(excludeFilter)) continue;
            File f = FileTool.buildRelativePath((File)new File(phome), (File)new File(ecps[i]));
            v.add(f.getPath());
        }
        return v.toArray(new String[0]);
    }

    private String getStringSplitter(Object key) {
        if (OPENL_CLASSPATH_PROPERTY.equals(key)) {
            return File.pathSeparator;
        }
        return null;
    }

    public String loadExistingClasspath(String projectHome) {
        Properties p = this.loadProjectProperties(projectHome);
        if (p == null) {
            return null;
        }
        return p.getProperty(OPENL_CLASSPATH_PROPERTY);
    }

    public String loadExistingClasspathSeparator(String projectHome) {
        Properties p = this.loadProjectProperties(projectHome);
        if (p == null) {
            return null;
        }
        return p.getProperty(OPENL_CLASSPATH_SEPARATOR_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProjectProperties(String projectHome) {
        FileInputStream fis = null;
        try {
            Properties p = new Properties();
            fis = new FileInputStream(new File(OpenLProjectPropertiesLoader.getOpenLPropertiesFolder(projectHome), OPENL_PROPERTIES_FNAME));
            p.load(fis);
            Properties properties = p;
            return properties;
        }
        catch (Exception ex) {
            Properties properties = null;
            return properties;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Log.error((Object)e);
                }
            }
        }
    }

    Properties mergeProperties(Properties p, Properties old) {
        if (old == null) {
            return p;
        }
        boolean newProps = false;
        for (Map.Entry<Object, Object> element : old.entrySet()) {
            Object x = p.get(element.getKey());
            if (x == null) {
                p.put(element.getKey(), element.getValue());
                continue;
            }
            if (x.equals(element.getValue())) continue;
            newProps = true;
        }
        if (newProps || p.size() != old.size()) {
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveClasspath(String[] cp, String projectHome) throws IOException {
        String ecp = this.loadExistingClasspath(projectHome);
        if (ecp == null || !OpenLProjectPropertiesLoader.isTheSame(ecp, cp)) {
            String folder = OpenLProjectPropertiesLoader.getOpenLPropertiesFolder(projectHome);
            try (OutputStreamWriter fw = null;){
                fw = new FileWriter(new File(folder, OPENL_PROPERTIES_FNAME));
                fw.write("openl.project.classpath=");
                for (int i = 0; i < cp.length; ++i) {
                    fw.write("\\\n" + cp[i] + File.pathSeparator);
                }
            }
        }
    }

    public void saveProperties(String projectHome, Properties p) {
        this.saveProperties(projectHome, p, false);
    }

    public void saveProperties(String projectHome, Properties p, boolean override) {
        if (override) {
            this.writeProperties(projectHome, p);
        } else {
            Properties old = this.loadProjectProperties(projectHome);
            Properties m = this.mergeProperties(p, old);
            if (m != null) {
                this.writeProperties(projectHome, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperties(String projectHome, Properties p) {
        String folder = OpenLProjectPropertiesLoader.getOpenLPropertiesFolder(projectHome);
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(new File(folder, OPENL_PROPERTIES_FNAME));
            for (Map.Entry<Object, Object> element : p.entrySet()) {
                this.writeSingleProperty(element, fw);
            }
        }
        catch (Exception ex) {
            Log.error((Object)("Error writing " + folder + "/" + OPENL_PROPERTIES_FNAME), (Throwable)ex);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    Log.error((Object)("Error writing " + folder + "/" + OPENL_PROPERTIES_FNAME), (Throwable)e);
                }
            }
        }
    }

    public void writeSingleProperty(Map.Entry<Object, Object> element, Writer w) throws IOException {
        w.write("" + element.getKey() + "=");
        String splitter = this.getStringSplitter(element.getKey());
        if (splitter == null) {
            this.writeValue(element.getValue(), w);
            w.write("\n\n");
            return;
        }
        String[] tokens = StringTool.tokenize((String)((String)element.getValue()), (String)splitter);
        for (int i = 0; i < tokens.length; ++i) {
            if (i + 1 < tokens.length) {
                this.writeValue(tokens[i] + splitter + '\\', w);
            } else {
                this.writeValue(tokens[i] + splitter + '\n', w);
            }
            w.write(10);
        }
    }

    private void writeValue(Object value, Writer w) throws IOException {
        w.write((String)value);
    }
}

