/*
 * Decompiled with CFR 0.152.
 */
package org.openl.main;

import java.io.PrintWriter;
import org.openl.exception.OpenLException;
import org.openl.main.SourceCodeURLConstants;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.CompositeSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.util.StringTool;
import org.openl.util.StringUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceCodeURLTool
implements SourceCodeURLConstants {
    public static String makeSourceLocationURL(ILocation location, IOpenSourceCodeModule module) {
        String moduleUri;
        Logger log = LoggerFactory.getLogger(SourceCodeURLTool.class);
        if (module != null && StringUtils.isEmpty((CharSequence)module.getUri())) {
            return "";
        }
        int start = -1;
        int end = -1;
        String lineInfo = null;
        if (module == null) {
            return "NO_MODULE";
        }
        if (location != null && location.isTextLocation()) {
            String src = module.getCode();
            TextInfo info = new TextInfo(src);
            try {
                start = location.getStart().getAbsolutePosition(info) + module.getStartPosition();
                end = location.getEnd().getAbsolutePosition(info) + module.getStartPosition();
            }
            catch (UnsupportedOperationException e) {
                log.warn("Cannot make source location URL", (Throwable)e);
            }
            lineInfo = "start=" + start + "&" + "end" + "=" + end;
        }
        String suffix = !(moduleUri = SourceCodeURLTool.getUri(module, location)).contains("?") ? "?" : "&";
        String url = moduleUri;
        if (lineInfo != null) {
            url = url + suffix + lineInfo;
        } else if (location != null) {
            url = url + suffix + location;
        }
        return url;
    }

    private static String getUri(IOpenSourceCodeModule module, ILocation location) {
        String moduleUri;
        if (module instanceof CompositeSourceCodeModule && location != null && location.isTextLocation()) {
            int line = location.getStart().getLine(new TextInfo(module.getCode()));
            IOpenSourceCodeModule[] modules = ((CompositeSourceCodeModule)module).getModules();
            if (modules.length <= line) {
                Logger log = LoggerFactory.getLogger(SourceCodeURLTool.class);
                log.warn("Modules count in composite module are less than error line number. Return first found module uri.");
                moduleUri = module.getUri();
            } else {
                IOpenSourceCodeModule actualModule = modules[line];
                moduleUri = actualModule == null ? module.getUri() : actualModule.getUri();
            }
        } else {
            moduleUri = module.getUri();
        }
        return moduleUri;
    }

    public static void printCodeAndError(ILocation location, IOpenSourceCodeModule module, PrintWriter pw) {
        if (location == null) {
            return;
        }
        if (!location.isTextLocation()) {
            return;
        }
        String src = module.getCode();
        TextInfo info = new TextInfo(src);
        String[] lines = StringTool.splitLines((String)src);
        pw.println("Openl Code Fragment:");
        pw.println("=======================");
        int line1 = location.getStart().getLine(info);
        int column1 = location.getStart().getColumn(info, 1);
        int line2 = location.getEnd().getLine(info);
        int column2 = location.getEnd().getColumn(info, 1);
        int start = Math.max(line1 - 2, 0);
        int end = Math.min(start + 4, lines.length);
        for (int i = start; i < end; ++i) {
            String line = StringTool.untab((String)lines[i], (int)2);
            pw.println(line);
            if (i != line1) continue;
            StringBuilder buf = new StringBuilder(Math.max(column1, column2) + 5);
            StringTool.append((StringBuilder)buf, (char)' ', (int)column1);
            int col2 = line1 == line2 ? column2 + 1 : line.length();
            StringTool.append((StringBuilder)buf, (char)'^', (int)(col2 - column1));
            pw.println(buf.toString());
        }
        pw.println("=======================");
    }

    public static void printSourceLocation(ILocation location, IOpenSourceCodeModule module, PrintWriter pw) {
        String url = SourceCodeURLTool.makeSourceLocationURL(location, module);
        if (!StringUtils.isEmpty((CharSequence)url)) {
            pw.println("    at " + url);
        }
    }

    public static void printSourceLocation(OpenLException error, PrintWriter pw) {
        SourceCodeURLTool.printSourceLocation(error.getLocation(), error.getSourceModule(), pw);
    }

    public static void printSourceLocation(ISyntaxNode node, PrintWriter pw) {
        SourceCodeURLTool.printSourceLocation(node.getSourceLocation(), node.getModule(), pw);
    }
}

