/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.binding.impl.operator.Comparison;
import org.openl.exception.OpenLRuntimeException;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=BigDecimalValueAdapter.class)
public class BigDecimalValue
extends ExplanationNumberValue<BigDecimalValue> {
    private static final long serialVersionUID = 1996508840075924034L;
    private static final BigDecimalValue ZERO = new BigDecimalValue("0");
    private static final BigDecimalValue ONE = new BigDecimalValue("1");
    private static final BigDecimalValue MINUS_ONE = new BigDecimalValue("-1");
    private final BigDecimal value;

    public static boolean eq(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        return Comparison.eq(value1.getValue(), value2.getValue());
    }

    public static Boolean ge(BigDecimalValue value1, BigDecimalValue value2) {
        BigDecimal v1 = value1 == null ? null : value1.value;
        BigDecimal v2 = value2 == null ? null : value2.value;
        return Comparison.ge(v1, v2);
    }

    public static Boolean gt(BigDecimalValue value1, BigDecimalValue value2) {
        BigDecimal v1 = value1 == null ? null : value1.value;
        BigDecimal v2 = value2 == null ? null : value2.value;
        return Comparison.gt(v1, v2);
    }

    public static Boolean le(BigDecimalValue value1, BigDecimalValue value2) {
        BigDecimal v1 = value1 == null ? null : value1.value;
        BigDecimal v2 = value2 == null ? null : value2.value;
        return Comparison.le(v1, v2);
    }

    public static Boolean lt(BigDecimalValue value1, BigDecimalValue value2) {
        BigDecimal v1 = value1 == null ? null : value1.value;
        BigDecimal v2 = value2 == null ? null : value2.value;
        return Comparison.lt(v1, v2);
    }

    public static boolean ne(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return Comparison.ne(value1.getValue(), value2.getValue());
    }

    public static BigDecimalValue avg(BigDecimalValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigDecimal[] unwrappedArray = BigDecimalValue.unwrap(values);
        BigDecimal avg = MathUtils.avg((BigDecimal[])unwrappedArray);
        return new BigDecimalValue(new BigDecimalValue(avg), NumberOperations.AVG, values);
    }

    public static BigDecimalValue sum(BigDecimalValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigDecimal[] unwrappedArray = BigDecimalValue.unwrap(values);
        BigDecimal sum = MathUtils.sum((BigDecimal[])unwrappedArray);
        return new BigDecimalValue(new BigDecimalValue(sum), NumberOperations.SUM, values);
    }

    public static BigDecimalValue median(BigDecimalValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigDecimal[] unwrappedArray = BigDecimalValue.unwrap(values);
        BigDecimal median = MathUtils.median((BigDecimal[])unwrappedArray);
        return new BigDecimalValue(new BigDecimalValue(median), NumberOperations.MEDIAN, values);
    }

    public static BigDecimalValue max(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigDecimalValue(MathUtils.max((Comparable)value1.getValue(), (Comparable)value2.getValue()) != false ? value1 : value2, NumberOperations.MAX, new BigDecimalValue[]{value1, value2});
    }

    public static BigDecimalValue min(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigDecimalValue(MathUtils.min((Comparable)value1.getValue(), (Comparable)value2.getValue()) != false ? value1 : value2, NumberOperations.MIN, new BigDecimalValue[]{value1, value2});
    }

    public static BigDecimalValue max(BigDecimalValue[] values) {
        BigDecimalValue result = (BigDecimalValue)MathUtils.max((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new BigDecimalValue((BigDecimalValue)BigDecimalValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static BigDecimalValue min(BigDecimalValue[] values) {
        BigDecimalValue result = (BigDecimalValue)MathUtils.min((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new BigDecimalValue((BigDecimalValue)BigDecimalValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static BigDecimalValue copy(BigDecimalValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            BigDecimalValue result = new BigDecimalValue(value, NumberOperations.COPY, new BigDecimalValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static BigDecimalValue rem(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new BigDecimalValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static String add(BigDecimalValue value1, String value2) {
        return value1 + value2;
    }

    public static String add(String value1, BigDecimalValue value2) {
        return value1 + value2;
    }

    public static BigDecimalValue add(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigDecimalValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static BigDecimalValue multiply(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigDecimalValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static BigDecimalValue subtract(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return BigDecimalValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new BigDecimalValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static BigDecimalValue divide(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new BigDecimalValue(value1, value2, BigDecimalValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new BigDecimalValue(value1, value2, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenLRuntimeException("Division by zero");
        }
        return new BigDecimalValue(value1, value2, Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(BigDecimalValue number, BigDecimalValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((BigDecimal)number.getValue(), (BigDecimal)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static BigDecimalValue product(BigDecimalValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigDecimal[] unwrappedArray = BigDecimalValue.unwrap(values);
        BigDecimal product = MathUtils.product((BigDecimal[])unwrappedArray);
        return new BigDecimalValue(new BigDecimalValue(product), NumberOperations.PRODUCT, null);
    }

    public static BigDecimalValue mod(BigDecimalValue number, BigDecimalValue divisor) {
        if (number != null && divisor != null) {
            BigDecimalValue result = new BigDecimalValue(MathUtils.mod((BigDecimal)number.getValue(), (BigDecimal)divisor.getValue()));
            return new BigDecimalValue(result, NumberOperations.MOD, new BigDecimalValue[]{number, divisor});
        }
        return null;
    }

    public static BigDecimalValue small(BigDecimalValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = BigDecimalValue.unwrap(values);
        BigDecimal small = (BigDecimal)MathUtils.small((Comparable[])unwrappedArray, (int)position);
        return new BigDecimalValue((BigDecimalValue)BigDecimalValue.getAppropriateValue(values, new BigDecimalValue(small)), NumberOperations.SMALL, values);
    }

    public static BigDecimalValue big(BigDecimalValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = BigDecimalValue.unwrap(values);
        BigDecimal big = (BigDecimal)MathUtils.big((Comparable[])unwrappedArray, (int)position);
        return new BigDecimalValue((BigDecimalValue)BigDecimalValue.getAppropriateValue(values, new BigDecimalValue(big)), NumberOperations.BIG, values);
    }

    public static BigDecimalValue pow(BigDecimalValue value1, BigDecimalValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new BigDecimalValue("0");
        }
        if (value2 == null) {
            return value1;
        }
        return new BigDecimalValue(new BigDecimalValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new BigDecimalValue[]{value1, value2});
    }

    public static BigDecimalValue abs(BigDecimalValue value) {
        if (value == null) {
            return null;
        }
        BigDecimalValue result = new BigDecimalValue(Operators.abs(value.getValue()));
        return new BigDecimalValue(result, NumberOperations.ABS, new BigDecimalValue[]{value});
    }

    public static BigDecimalValue negative(BigDecimalValue value) {
        if (value == null) {
            return null;
        }
        return BigDecimalValue.multiply(value, MINUS_ONE);
    }

    public static BigDecimalValue inc(BigDecimalValue value) {
        return BigDecimalValue.add(value, ONE);
    }

    public static BigDecimalValue positive(BigDecimalValue value) {
        return value;
    }

    public static BigDecimalValue dec(BigDecimalValue value) {
        return BigDecimalValue.subtract(value, ONE);
    }

    public static BigDecimalValue autocast(byte x, BigDecimalValue y) {
        return new BigDecimalValue(String.valueOf(x));
    }

    public static BigDecimalValue autocast(short x, BigDecimalValue y) {
        return new BigDecimalValue(String.valueOf(x));
    }

    public static BigDecimalValue autocast(int x, BigDecimalValue y) {
        return new BigDecimalValue(String.valueOf(x));
    }

    public static BigDecimalValue autocast(char x, BigDecimalValue y) {
        return new BigDecimalValue(String.valueOf((int)x));
    }

    public static BigDecimalValue autocast(long x, BigDecimalValue y) {
        return new BigDecimalValue(String.valueOf(x));
    }

    public static BigDecimalValue autocast(float x, BigDecimalValue y) {
        return new BigDecimalValue(String.valueOf(x));
    }

    public static BigDecimalValue autocast(double x, BigDecimalValue y) {
        return new BigDecimalValue(String.valueOf(x));
    }

    public BigDecimalValue(BigDecimal value) {
        this.value = value;
    }

    public BigDecimalValue(BigDecimalValue lv1, BigDecimalValue lv2, BigDecimal value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public BigDecimalValue(String valueString, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("BigDecimalValue", autocast));
        this.value = new BigDecimal(valueString);
    }

    @Override
    public BigDecimalValue copy(String name) {
        return BigDecimalValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BigDecimalValue) {
            BigDecimalValue secondObj = (BigDecimalValue)obj;
            return Comparison.eq(this.getValue(), secondObj.getValue());
        }
        return false;
    }

    public static BigDecimalValue[] sort(BigDecimalValue[] values) {
        BigDecimalValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new BigDecimalValue[values.length];
            Object[] notNullArray = (BigDecimalValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            System.arraycopy(notNullArray, 0, sortedArray, 0, notNullArray.length);
        }
        return sortedArray;
    }

    public static BigDecimalValue autocast(BigInteger x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(new BigDecimal(x));
    }

    public static BigDecimalValue autocast(BigDecimal x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(x);
    }

    public static BigDecimalValue autocast(BigIntegerValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(new BigDecimal(x.getValue()));
    }

    public static byte cast(BigDecimalValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(BigDecimalValue x, short y) {
        return x.shortValue();
    }

    public static char cast(BigDecimalValue x, char y) {
        return (char)x.intValue();
    }

    public static int cast(BigDecimalValue x, int y) {
        return x.intValue();
    }

    public static long cast(BigDecimalValue x, long y) {
        return x.longValue();
    }

    public static float cast(BigDecimalValue x, float y) {
        return x.floatValue();
    }

    public static double cast(BigDecimalValue x, double y) {
        return x.doubleValue();
    }

    public static BigDecimal cast(BigDecimalValue x, BigDecimal y) {
        if (x == null) {
            return null;
        }
        return x.getValue();
    }

    public static BigInteger cast(BigDecimalValue x, BigInteger y) {
        if (x == null) {
            return null;
        }
        return x.getValue().toBigInteger();
    }

    public static ByteValue cast(BigDecimalValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(BigDecimalValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public static IntValue cast(BigDecimalValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.intValue(), x, false);
    }

    public static LongValue cast(BigDecimalValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.longValue(), x, false);
    }

    public static FloatValue cast(BigDecimalValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.floatValue(), x, false);
    }

    public static DoubleValue cast(BigDecimalValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.doubleValue(), x, false);
    }

    public static BigIntegerValue cast(BigDecimalValue x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(String.valueOf(x.longValue()), x, false);
    }

    public static BigDecimalValue round(BigDecimalValue value) {
        return BigDecimalValue.round(value, 0);
    }

    public static BigDecimalValue round(BigDecimalValue value, int scale) {
        return BigDecimalValue.round(value, scale, 4);
    }

    public static BigDecimalValue round(BigDecimalValue value, int scale, int roundingMethod) {
        if (value == null) {
            return null;
        }
        return new BigDecimalValue(new BigDecimalValue(value.getValue().setScale(scale, roundingMethod)), NumberOperations.ROUND, new BigDecimalValue[]{value});
    }

    public BigDecimalValue(String valueString) {
        this.value = new BigDecimal(valueString);
    }

    public BigDecimalValue(BigDecimalValue result, NumberOperations function, BigDecimalValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.getValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public int compareTo(BigDecimalValue o) {
        return this.value.compareTo(o.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    private static BigDecimal[] unwrap(BigDecimalValue[] values) {
        values = (BigDecimalValue[])ArrayTool.removeNulls((Object[])values);
        BigDecimal[] unwrappedArray = new BigDecimal[values.length];
        for (int i = 0; i < values.length; ++i) {
            unwrappedArray[i] = values[i].getValue();
        }
        return unwrappedArray;
    }

    public static class BigDecimalValueAdapter
    extends XmlAdapter<BigDecimal, BigDecimalValue> {
        public BigDecimalValue unmarshal(BigDecimal val) throws Exception {
            return new BigDecimalValue(val);
        }

        public BigDecimal marshal(BigDecimalValue val) throws Exception {
            return val.getValue();
        }
    }
}

