/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.exception.OpenLRuntimeException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=BigIntegerValueAdapter.class)
public class BigIntegerValue
extends ExplanationNumberValue<BigIntegerValue> {
    private static final long serialVersionUID = -3936317402079096501L;
    public static final BigIntegerValue ZERO = new BigIntegerValue("0");
    public static final BigIntegerValue ONE = new BigIntegerValue("1");
    public static final BigIntegerValue MINUS_ONE = new BigIntegerValue("-1");
    private final BigInteger value;

    private static BigDecimalValue[] toBigDecimalValueValues(BigIntegerValue[] values) {
        if (values == null) {
            return null;
        }
        BigDecimalValue[] doubleValues = new BigDecimalValue[values.length];
        int i = 0;
        for (BigIntegerValue value : values) {
            doubleValues[i] = BigDecimalValue.autocast(value, new BigDecimalValue("0"));
            ++i;
        }
        return doubleValues;
    }

    public static BigDecimalValue avg(BigIntegerValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] unwrappedArray = BigIntegerValue.unwrap(values);
        BigDecimal avg = MathUtils.avg((BigInteger[])unwrappedArray);
        return new BigDecimalValue(new BigDecimalValue(avg), NumberOperations.AVG, BigIntegerValue.toBigDecimalValueValues(values));
    }

    public static BigIntegerValue sum(BigIntegerValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] unwrappedArray = BigIntegerValue.unwrap(values);
        BigInteger sum = MathUtils.sum((BigInteger[])unwrappedArray);
        return new BigIntegerValue(new BigIntegerValue(sum), NumberOperations.SUM, values);
    }

    public static BigIntegerValue median(BigIntegerValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] unwrappedArray = BigIntegerValue.unwrap(values);
        BigInteger median = MathUtils.median((BigInteger[])unwrappedArray);
        return new BigIntegerValue(new BigIntegerValue(median), NumberOperations.MEDIAN, values);
    }

    public static BigIntegerValue max(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(MathUtils.max((Comparable)value1.getValue(), (Comparable)value2.getValue()) != false ? value1 : value2, NumberOperations.MAX, new BigIntegerValue[]{value1, value2});
    }

    public static BigIntegerValue min(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(MathUtils.min((Comparable)value1.getValue(), (Comparable)value2.getValue()) != false ? value1 : value2, NumberOperations.MIN, new BigIntegerValue[]{value1, value2});
    }

    public static BigIntegerValue max(BigIntegerValue[] values) {
        BigIntegerValue result = (BigIntegerValue)MathUtils.max((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new BigIntegerValue((BigIntegerValue)BigIntegerValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static BigIntegerValue min(BigIntegerValue[] values) {
        BigIntegerValue result = (BigIntegerValue)MathUtils.min((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new BigIntegerValue((BigIntegerValue)BigIntegerValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static BigIntegerValue copy(BigIntegerValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            BigIntegerValue result = new BigIntegerValue(value, NumberOperations.COPY, new BigIntegerValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static BigIntegerValue rem(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new BigIntegerValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static String add(BigIntegerValue value1, String value2) {
        return value1 + value2;
    }

    public static String add(String value1, BigIntegerValue value2) {
        return value1 + value2;
    }

    public static BigIntegerValue add(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static BigIntegerValue multiply(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static BigIntegerValue subtract(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return BigIntegerValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static BigDecimalValue divide(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new BigDecimalValue(null, new BigDecimalValue(new BigDecimal(value2.getValue())), BigIntegerValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new BigDecimalValue(new BigDecimalValue(new BigDecimal(value1.getValue())), null, new BigDecimal(value1.getValue()), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenLRuntimeException("Division by zero");
        }
        return new BigDecimalValue(new BigDecimalValue(new BigDecimal(value1.getValue())), new BigDecimalValue(new BigDecimal(value2.getValue())), Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(BigIntegerValue number, BigIntegerValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((BigInteger)number.getValue(), (BigInteger)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static BigIntegerValue product(BigIntegerValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] unwrappedArray = BigIntegerValue.unwrap(values);
        BigInteger product = MathUtils.product((BigInteger[])unwrappedArray);
        return new BigIntegerValue(new BigIntegerValue(product), NumberOperations.PRODUCT, null);
    }

    public static BigIntegerValue mod(BigIntegerValue number, BigIntegerValue divisor) {
        if (number != null && divisor != null) {
            BigIntegerValue result = new BigIntegerValue(MathUtils.mod((BigInteger)number.getValue(), (BigInteger)divisor.getValue()));
            return new BigIntegerValue(result, NumberOperations.MOD, new BigIntegerValue[]{number, divisor});
        }
        return null;
    }

    public static BigIntegerValue small(BigIntegerValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = BigIntegerValue.unwrap(values);
        BigInteger small = (BigInteger)MathUtils.small((Comparable[])unwrappedArray, (int)position);
        return new BigIntegerValue((BigIntegerValue)BigIntegerValue.getAppropriateValue(values, new BigIntegerValue(small)), NumberOperations.SMALL, values);
    }

    public static BigIntegerValue big(BigIntegerValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = BigIntegerValue.unwrap(values);
        BigInteger big = (BigInteger)MathUtils.big((Comparable[])unwrappedArray, (int)position);
        return new BigIntegerValue((BigIntegerValue)BigIntegerValue.getAppropriateValue(values, new BigIntegerValue(big)), NumberOperations.BIG, values);
    }

    public static BigIntegerValue pow(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new BigIntegerValue("0");
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(new BigIntegerValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new BigIntegerValue[]{value1, value2});
    }

    public static BigIntegerValue abs(BigIntegerValue value) {
        if (value == null) {
            return null;
        }
        BigIntegerValue result = new BigIntegerValue(Operators.abs(value.getValue()));
        return new BigIntegerValue(result, NumberOperations.ABS, new BigIntegerValue[]{value});
    }

    public static BigIntegerValue negative(BigIntegerValue value) {
        if (value == null) {
            return null;
        }
        return BigIntegerValue.multiply(value, MINUS_ONE);
    }

    public static BigIntegerValue inc(BigIntegerValue value) {
        return BigIntegerValue.add(value, ONE);
    }

    public static BigIntegerValue positive(BigIntegerValue value) {
        return value;
    }

    public static BigIntegerValue dec(BigIntegerValue value) {
        return BigIntegerValue.subtract(value, ONE);
    }

    public static BigIntegerValue autocast(byte x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf(x));
    }

    public static BigIntegerValue autocast(short x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf(x));
    }

    public static BigIntegerValue autocast(int x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf(x));
    }

    public static BigIntegerValue autocast(char x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf((int)x));
    }

    public static BigIntegerValue autocast(long x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf(x));
    }

    public BigIntegerValue(BigInteger value) {
        this.value = value;
    }

    public BigIntegerValue(BigIntegerValue lv1, BigIntegerValue lv2, BigInteger value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public BigIntegerValue(String valueString, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("BigIntegerValue", autocast));
        this.value = new BigInteger(valueString);
    }

    @Override
    public BigIntegerValue copy(String name) {
        return BigIntegerValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public BigInteger getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof BigIntegerValue && this.value.equals(((BigIntegerValue)obj).value);
    }

    public static BigIntegerValue[] sort(BigIntegerValue[] values) {
        BigIntegerValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new BigIntegerValue[values.length];
            Object[] notNullArray = (BigIntegerValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            System.arraycopy(notNullArray, 0, sortedArray, 0, notNullArray.length);
        }
        return sortedArray;
    }

    public static BigIntegerValue autocast(BigInteger x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(x);
    }

    public static BigIntegerValue cast(float x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf((long)x));
    }

    public static BigIntegerValue cast(double x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf((long)x));
    }

    public static BigIntegerValue cast(FloatValue x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(String.valueOf(x.longValue()));
    }

    public static BigIntegerValue cast(DoubleValue x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(String.valueOf(x.longValue()));
    }

    public static BigIntegerValue cast(BigDecimal x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(x.toBigInteger());
    }

    public static byte cast(BigIntegerValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(BigIntegerValue x, short y) {
        return x.shortValue();
    }

    public static char cast(BigIntegerValue x, char y) {
        return (char)x.intValue();
    }

    public static int cast(BigIntegerValue x, int y) {
        return x.intValue();
    }

    public static long cast(BigIntegerValue x, long y) {
        return x.longValue();
    }

    public static float cast(BigIntegerValue x, float y) {
        return x.floatValue();
    }

    public static double cast(BigIntegerValue x, double y) {
        return x.doubleValue();
    }

    public static BigInteger cast(BigIntegerValue x, BigInteger y) {
        if (x == null) {
            return null;
        }
        return x.getValue();
    }

    public static BigDecimal cast(BigIntegerValue x, BigDecimal y) {
        if (x == null) {
            return null;
        }
        return new BigDecimal(x.getValue());
    }

    public static ByteValue cast(BigIntegerValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(BigIntegerValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public static IntValue cast(BigIntegerValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.intValue(), x, false);
    }

    public static LongValue cast(BigIntegerValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.longValue(), x, false);
    }

    public static FloatValue cast(BigIntegerValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.floatValue(), x, false);
    }

    public static DoubleValue cast(BigIntegerValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.doubleValue(), x, false);
    }

    public BigIntegerValue(String valueString) {
        this.value = new BigInteger(valueString);
    }

    public BigIntegerValue(BigIntegerValue result, NumberOperations function, BigIntegerValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.getValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public int compareTo(BigIntegerValue o) {
        return this.value.compareTo(o.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    private static BigInteger[] unwrap(BigIntegerValue[] values) {
        values = (BigIntegerValue[])ArrayTool.removeNulls((Object[])values);
        BigInteger[] unwrapArray = new BigInteger[values.length];
        for (int i = 0; i < values.length; ++i) {
            unwrapArray[i] = values[i].value;
        }
        return unwrapArray;
    }

    public static class BigIntegerValueAdapter
    extends XmlAdapter<BigInteger, BigIntegerValue> {
        public BigIntegerValue unmarshal(BigInteger val) throws Exception {
            return new BigIntegerValue(val);
        }

        public BigInteger marshal(BigIntegerValue val) throws Exception {
            return val.getValue();
        }
    }
}

