/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.binding.impl.operator.Comparison;
import org.openl.exception.OpenLRuntimeException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.ByteValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.NumberOperations;
import org.openl.rules.util.Round;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
public class DoubleValue
extends ExplanationNumberValue<DoubleValue> {
    private static final long serialVersionUID = -4594250562069599646L;
    public static final DoubleValue ZERO = new DoubleValueZero();
    public static final DoubleValue ONE = new DoubleValueOne();
    public static final DoubleValue MINUS_ONE = new DoubleValue(-1.0);
    private double value;

    public void setValue(double value) {
        this.value = value;
    }

    public static boolean eq(DoubleValue value1, DoubleValue value2) {
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        return Comparison.eq(value1.getValue(), value2.getValue());
    }

    public static Boolean ge(DoubleValue value1, DoubleValue value2) {
        Double v1 = value1 == null ? null : Double.valueOf(value1.value);
        Double v2 = value2 == null ? null : Double.valueOf(value2.value);
        return Comparison.ge(v1, v2);
    }

    public static Boolean gt(DoubleValue value1, DoubleValue value2) {
        Double v1 = value1 == null ? null : Double.valueOf(value1.value);
        Double v2 = value2 == null ? null : Double.valueOf(value2.value);
        return Comparison.gt(v1, v2);
    }

    public static Boolean le(DoubleValue value1, DoubleValue value2) {
        Double v1 = value1 == null ? null : Double.valueOf(value1.value);
        Double v2 = value2 == null ? null : Double.valueOf(value2.value);
        return Comparison.le(v1, v2);
    }

    public static Boolean lt(DoubleValue value1, DoubleValue value2) {
        Double v1 = value1 == null ? null : Double.valueOf(value1.value);
        Double v2 = value2 == null ? null : Double.valueOf(value2.value);
        return Comparison.lt(v1, v2);
    }

    public static boolean ne(DoubleValue value1, DoubleValue value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return Comparison.ne(value1.getValue(), value2.getValue());
    }

    public static DoubleValue avg(DoubleValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Number[] unwrappedArray = DoubleValue.unwrap(values);
        Double avg = MathUtils.avg((Number[])unwrappedArray);
        return new DoubleValue(new DoubleValue(avg), NumberOperations.AVG, values);
    }

    public static DoubleValue sum(DoubleValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Double[] unwrappedArray = DoubleValue.unwrap(values);
        Double sum = MathUtils.sum((Double[])unwrappedArray);
        return new DoubleValue(new DoubleValue(sum), NumberOperations.SUM, values);
    }

    public static DoubleValue median(DoubleValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Number[] unwrappedArray = DoubleValue.unwrap(values);
        Double median = MathUtils.median((Number[])unwrappedArray);
        return new DoubleValue(new DoubleValue(median), NumberOperations.MEDIAN, values);
    }

    public static DoubleValue max(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(MathUtils.max((double)value1.getValue(), (double)value2.getValue()) ? value1 : value2, NumberOperations.MAX, value1, value2);
    }

    public static DoubleValue min(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(MathUtils.min((double)value1.getValue(), (double)value2.getValue()) ? value1 : value2, NumberOperations.MIN, value1, value2);
    }

    public static DoubleValue max(DoubleValue[] values) {
        DoubleValue result = (DoubleValue)MathUtils.max((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new DoubleValue((DoubleValue)DoubleValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static DoubleValue min(DoubleValue[] values) {
        DoubleValue result = (DoubleValue)MathUtils.min((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new DoubleValue((DoubleValue)DoubleValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static DoubleValue copy(DoubleValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            DoubleValue result = new DoubleValue(value, NumberOperations.COPY, value);
            result.setName(name);
            return result;
        }
        return value;
    }

    public static DoubleValue rem(DoubleValue value1, DoubleValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new DoubleValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static String add(DoubleValue value1, String value2) {
        return value1 + value2;
    }

    public static String add(String value1, DoubleValue value2) {
        return value1 + value2;
    }

    public static DoubleValue add(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static DoubleValue multiply(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static DoubleValue subtract(DoubleValue value1, DoubleValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return DoubleValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static DoubleValue divide(DoubleValue value1, DoubleValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new DoubleValue(value1, value2, DoubleValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new DoubleValue(value1, value2, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            return new DoubleValue(value1, value2, Double.POSITIVE_INFINITY, Formulas.DIVIDE);
        }
        return new DoubleValue(value1, value2, Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(DoubleValue number, DoubleValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((double)number.getValue(), (double)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static DoubleValue product(DoubleValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Double[] unwrappedArray = DoubleValue.unwrap(values);
        double product = MathUtils.product((Double[])unwrappedArray);
        return new DoubleValue(new DoubleValue(product), NumberOperations.PRODUCT, null);
    }

    public static DoubleValue mod(DoubleValue number, DoubleValue divisor) {
        if (number != null && divisor != null) {
            DoubleValue result = new DoubleValue(MathUtils.mod((double)number.getValue(), (double)divisor.getValue()));
            return new DoubleValue(result, NumberOperations.MOD, number, divisor);
        }
        return null;
    }

    public static DoubleValue small(DoubleValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = DoubleValue.unwrap(values);
        Double small = (Double)MathUtils.small((Comparable[])unwrappedArray, (int)position);
        return new DoubleValue((DoubleValue)DoubleValue.getAppropriateValue(values, new DoubleValue(small)), NumberOperations.SMALL, values);
    }

    public static DoubleValue big(DoubleValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = DoubleValue.unwrap(values);
        Double big = (Double)MathUtils.big((Comparable[])unwrappedArray, (int)position);
        return new DoubleValue((DoubleValue)DoubleValue.getAppropriateValue(values, new DoubleValue(big)), NumberOperations.BIG, values);
    }

    public static DoubleValue pow(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new DoubleValue(0.0);
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(new DoubleValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, value1, value2);
    }

    public static DoubleValue abs(DoubleValue value) {
        if (value == null) {
            return null;
        }
        DoubleValue result = new DoubleValue(Operators.abs(value.getValue()));
        return new DoubleValue(result, NumberOperations.ABS, value);
    }

    public static DoubleValue negative(DoubleValue value) {
        if (value == null) {
            return null;
        }
        return DoubleValue.multiply(value, MINUS_ONE);
    }

    public static DoubleValue inc(DoubleValue value) {
        return DoubleValue.add(value, ONE);
    }

    public static DoubleValue positive(DoubleValue value) {
        return value;
    }

    public static DoubleValue dec(DoubleValue value) {
        return DoubleValue.subtract(value, ONE);
    }

    public static DoubleValue autocast(byte x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(short x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(int x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(char x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(long x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(float x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(double x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public DoubleValue(double value) {
        this.value = value;
    }

    public DoubleValue(DoubleValue lv1, DoubleValue lv2, double value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public DoubleValue(double value, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("DoubleValue", autocast));
        this.value = value;
    }

    @Override
    public DoubleValue copy(String name) {
        return DoubleValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleValue) {
            DoubleValue secondObj = (DoubleValue)obj;
            return Comparison.eq(this.getValue(), secondObj.getValue());
        }
        if (obj instanceof String) {
            double d;
            try {
                d = Double.parseDouble((String)obj);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return Comparison.eq(this.getValue(), d);
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static DoubleValue[] sort(DoubleValue[] values) {
        DoubleValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new DoubleValue[values.length];
            Object[] notNullArray = (DoubleValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            System.arraycopy(notNullArray, 0, sortedArray, 0, notNullArray.length);
        }
        return sortedArray;
    }

    public static BigDecimalValue autocast(DoubleValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(String.valueOf(x.getValue()), x, true);
    }

    public static DoubleValue cast(BigInteger x, DoubleValue y) {
        return new DoubleValue(x.doubleValue());
    }

    public static DoubleValue cast(BigDecimal x, DoubleValue y) {
        return new DoubleValue(x.doubleValue());
    }

    public static byte cast(DoubleValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(DoubleValue x, short y) {
        return x.shortValue();
    }

    public static char cast(DoubleValue x, char y) {
        return (char)x.doubleValue();
    }

    public static int cast(DoubleValue x, int y) {
        return x.intValue();
    }

    public static long cast(DoubleValue x, long y) {
        return x.longValue();
    }

    public static float cast(DoubleValue x, float y) {
        return x.floatValue();
    }

    public static double cast(DoubleValue x, double y) {
        return x.doubleValue();
    }

    public static ByteValue cast(DoubleValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(DoubleValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public static IntValue cast(DoubleValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.intValue(), x, false);
    }

    public static LongValue cast(DoubleValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.longValue(), x, false);
    }

    public static FloatValue cast(DoubleValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.floatValue(), x, false);
    }

    public static BigInteger cast(DoubleValue x, BigInteger y) {
        return BigInteger.valueOf(x.longValue());
    }

    public static BigDecimal cast(DoubleValue x, BigDecimal y) {
        return BigDecimal.valueOf(x.doubleValue());
    }

    public static DoubleValue round(DoubleValue value) {
        if (value == null) {
            return null;
        }
        double rounded = Round.round((double)value.value, (int)0);
        DoubleValue newValue = new DoubleValue(rounded);
        return new DoubleValue(newValue, NumberOperations.ROUND, value);
    }

    public static DoubleValue round(DoubleValue value, int scale) {
        if (value == null) {
            return null;
        }
        double rounded = Round.round((double)value.value, (int)scale);
        DoubleValue newValue = new DoubleValue(rounded);
        return new DoubleValue(newValue, NumberOperations.ROUND, value, new DoubleValue(scale));
    }

    public static DoubleValue round(DoubleValue value, int scale, int roundingMethod) {
        if (value == null) {
            return null;
        }
        double rounded = Round.round((Double)value.value, (int)scale, (int)roundingMethod);
        DoubleValue newValue = new DoubleValue(rounded);
        return new DoubleValue(newValue, NumberOperations.ROUND, value, new DoubleValue(scale));
    }

    @Deprecated
    public static DoubleValue round(DoubleValue d, DoubleValue p) {
        double preRoundedValue;
        int scale;
        if (d == null || p == null) {
            throw new OpenLRuntimeException("None of the arguments for 'round' operation can be null");
        }
        if (p.doubleValue() == 0.0) {
            scale = 0;
            preRoundedValue = d.doubleValue();
        } else {
            scale = (int)Round.round((double)(-Math.log10(p.doubleValue())), (int)0, (RoundingMode)Round.HALF_UP);
            preRoundedValue = d.doubleValue();
        }
        double roundedValue = Round.round((double)preRoundedValue, (int)scale, (RoundingMode)Round.HALF_UP);
        return new DoubleValue(new DoubleValue(roundedValue), NumberOperations.ROUND, d, p);
    }

    public DoubleValue(String valueString) {
        this.value = Double.parseDouble(valueString);
    }

    public DoubleValue(DoubleValue result, NumberOperations function, DoubleValue ... params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.doubleValue();
    }

    @Override
    public int compareTo(DoubleValue o) {
        return Double.compare(this.value, o.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Deprecated
    public String getFormat() {
        return null;
    }

    @Deprecated
    public void setFormat(String format) {
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    private static Double[] unwrap(DoubleValue[] values) {
        values = (DoubleValue[])ArrayTool.removeNulls((Object[])values);
        Double[] unwrappedArray = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            unwrappedArray[i] = values[i].getValue();
        }
        return unwrappedArray;
    }

    public static class DoubleValueZero
    extends DoubleValue {
        private static final long serialVersionUID = 3329865368482848868L;

        private DoubleValueZero() {
            super(0.0);
        }

        public DoubleValue add(DoubleValue dv) {
            return dv;
        }

        public DoubleValue divide(DoubleValue dv) {
            return this;
        }

        public DoubleValue multiply(DoubleValue dv) {
            return this;
        }
    }

    public static class DoubleValueAdapter
    extends XmlAdapter<Double, DoubleValue> {
        public DoubleValue unmarshal(Double val) throws Exception {
            return new DoubleValue(val);
        }

        public Double marshal(DoubleValue val) throws Exception {
            return val.doubleValue();
        }
    }

    public static class DoubleValueOne
    extends DoubleValue {
        private static final long serialVersionUID = 6347462002516785250L;

        private DoubleValueOne() {
            super(1.0);
        }

        public DoubleValue multiply(DoubleValue dv) {
            return dv;
        }
    }
}

