/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.binding.impl.operator.Comparison;
import org.openl.exception.OpenLRuntimeException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.NumberOperations;
import org.openl.rules.util.Round;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=FloatValueAdapter.class)
public class FloatValue
extends ExplanationNumberValue<FloatValue> {
    private static final long serialVersionUID = -8235832583740963916L;
    private static final FloatValue ZERO = new FloatValue(0.0f);
    private static final FloatValue ONE = new FloatValue(1.0f);
    private static final FloatValue MINUS_ONE = new FloatValue(-1.0f);
    private final float value;

    public static boolean eq(FloatValue value1, FloatValue value2) {
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        return Comparison.eq(value1.getValue(), value2.getValue());
    }

    public static Boolean ge(FloatValue value1, FloatValue value2) {
        Float v1 = value1 == null ? null : Float.valueOf(value1.value);
        Float v2 = value2 == null ? null : Float.valueOf(value2.value);
        return Comparison.ge(v1, v2);
    }

    public static Boolean gt(FloatValue value1, FloatValue value2) {
        Float v1 = value1 == null ? null : Float.valueOf(value1.value);
        Float v2 = value2 == null ? null : Float.valueOf(value2.value);
        return Comparison.gt(v1, v2);
    }

    public static Boolean le(FloatValue value1, FloatValue value2) {
        Float v1 = value1 == null ? null : Float.valueOf(value1.value);
        Float v2 = value2 == null ? null : Float.valueOf(value2.value);
        return Comparison.le(v1, v2);
    }

    public static Boolean lt(FloatValue value1, FloatValue value2) {
        Float v1 = value1 == null ? null : Float.valueOf(value1.value);
        Float v2 = value2 == null ? null : Float.valueOf(value2.value);
        return Comparison.lt(v1, v2);
    }

    public static boolean ne(FloatValue value1, FloatValue value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return Comparison.ne(value1.getValue(), value2.getValue());
    }

    public static FloatValue avg(FloatValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Float[] unwrappedArray = FloatValue.unwrap(values);
        Float avg = MathUtils.avg((Float[])unwrappedArray);
        return new FloatValue(new FloatValue(avg.floatValue()), NumberOperations.AVG, values);
    }

    public static FloatValue sum(FloatValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Float[] unwrappedArray = FloatValue.unwrap(values);
        Float sum = MathUtils.sum((Float[])unwrappedArray);
        return new FloatValue(new FloatValue(sum.floatValue()), NumberOperations.SUM, values);
    }

    public static FloatValue median(FloatValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Float[] unwrappedArray = FloatValue.unwrap(values);
        Float median = MathUtils.median((Float[])unwrappedArray);
        return new FloatValue(new FloatValue(median.floatValue()), NumberOperations.MEDIAN, values);
    }

    public static FloatValue max(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(MathUtils.max((float)value1.getValue(), (float)value2.getValue()) ? value1 : value2, NumberOperations.MAX, value1, value2);
    }

    public static FloatValue min(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(MathUtils.min((float)value1.getValue(), (float)value2.getValue()) ? value1 : value2, NumberOperations.MIN, value1, value2);
    }

    public static FloatValue max(FloatValue[] values) {
        FloatValue result = (FloatValue)MathUtils.max((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new FloatValue((FloatValue)FloatValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static FloatValue min(FloatValue[] values) {
        FloatValue result = (FloatValue)MathUtils.min((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new FloatValue((FloatValue)FloatValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static FloatValue copy(FloatValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            FloatValue result = new FloatValue(value, NumberOperations.COPY, value);
            result.setName(name);
            return result;
        }
        return value;
    }

    public static FloatValue rem(FloatValue value1, FloatValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new FloatValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static String add(FloatValue value1, String value2) {
        return value1 + value2;
    }

    public static String add(String value1, FloatValue value2) {
        return value1 + value2;
    }

    public static FloatValue add(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static FloatValue multiply(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static FloatValue subtract(FloatValue value1, FloatValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return FloatValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static FloatValue divide(FloatValue value1, FloatValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new FloatValue(value1, value2, FloatValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new FloatValue(value1, value2, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenLRuntimeException("Division by zero");
        }
        return new FloatValue(value1, value2, Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(FloatValue number, FloatValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((float)number.getValue(), (float)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static DoubleValue product(FloatValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Float[] unwrappedArray = FloatValue.unwrap(values);
        double product = MathUtils.product((Float[])unwrappedArray).floatValue();
        return new DoubleValue(new DoubleValue(product), NumberOperations.PRODUCT, null);
    }

    public static FloatValue mod(FloatValue number, FloatValue divisor) {
        if (number != null && divisor != null) {
            FloatValue result = new FloatValue(MathUtils.mod((float)number.getValue(), (float)divisor.getValue()));
            return new FloatValue(result, NumberOperations.MOD, number, divisor);
        }
        return null;
    }

    public static FloatValue small(FloatValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = FloatValue.unwrap(values);
        Float small = (Float)MathUtils.small((Comparable[])unwrappedArray, (int)position);
        return new FloatValue((FloatValue)FloatValue.getAppropriateValue(values, new FloatValue(small.floatValue())), NumberOperations.SMALL, values);
    }

    public static FloatValue big(FloatValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = FloatValue.unwrap(values);
        Float big = (Float)MathUtils.big((Comparable[])unwrappedArray, (int)position);
        return new FloatValue((FloatValue)FloatValue.getAppropriateValue(values, new FloatValue(big.floatValue())), NumberOperations.BIG, values);
    }

    public static FloatValue pow(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new FloatValue(0.0f);
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(new FloatValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, value1, value2);
    }

    public static FloatValue abs(FloatValue value) {
        if (value == null) {
            return null;
        }
        FloatValue result = new FloatValue(Operators.abs(value.getValue()));
        return new FloatValue(result, NumberOperations.ABS, value);
    }

    public static FloatValue negative(FloatValue value) {
        if (value == null) {
            return null;
        }
        return FloatValue.multiply(value, MINUS_ONE);
    }

    public static FloatValue inc(FloatValue value) {
        return FloatValue.add(value, ONE);
    }

    public static FloatValue positive(FloatValue value) {
        return value;
    }

    public static FloatValue dec(FloatValue value) {
        return FloatValue.subtract(value, ONE);
    }

    public static FloatValue autocast(byte x, FloatValue y) {
        return new FloatValue(x);
    }

    public static FloatValue autocast(short x, FloatValue y) {
        return new FloatValue(x);
    }

    public static FloatValue autocast(int x, FloatValue y) {
        return new FloatValue(x);
    }

    public static FloatValue autocast(char x, FloatValue y) {
        return new FloatValue(x);
    }

    public static FloatValue autocast(long x, FloatValue y) {
        return new FloatValue(x);
    }

    public static FloatValue autocast(float x, FloatValue y) {
        return new FloatValue(x);
    }

    public FloatValue(float value) {
        this.value = value;
    }

    public FloatValue(FloatValue lv1, FloatValue lv2, float value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public FloatValue(float value, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("FloatValue", autocast));
        this.value = value;
    }

    @Override
    public FloatValue copy(String name) {
        return FloatValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public float getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatValue) {
            FloatValue secondObj = (FloatValue)obj;
            return Comparison.eq(this.getValue(), secondObj.getValue());
        }
        return false;
    }

    public static FloatValue[] sort(FloatValue[] values) {
        FloatValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new FloatValue[values.length];
            Object[] notNullArray = (FloatValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            System.arraycopy(notNullArray, 0, sortedArray, 0, notNullArray.length);
        }
        return sortedArray;
    }

    public static DoubleValue autocast(FloatValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.getValue(), x, true);
    }

    public static BigDecimalValue autocast(FloatValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(String.valueOf(x.getValue()), x, true);
    }

    public static FloatValue cast(double x, FloatValue y) {
        return new FloatValue((float)x);
    }

    public static FloatValue cast(BigInteger x, FloatValue y) {
        return new FloatValue(x.floatValue());
    }

    public static FloatValue cast(BigDecimal x, FloatValue y) {
        return new FloatValue(x.floatValue());
    }

    public static byte cast(FloatValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(FloatValue x, short y) {
        return x.shortValue();
    }

    public static char cast(FloatValue x, char y) {
        return (char)x.floatValue();
    }

    public static int cast(FloatValue x, int y) {
        return x.intValue();
    }

    public static long cast(FloatValue x, long y) {
        return x.longValue();
    }

    public static float cast(FloatValue x, float y) {
        return x.floatValue();
    }

    public static double cast(FloatValue x, double y) {
        return x.doubleValue();
    }

    public static ByteValue cast(FloatValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(FloatValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public static IntValue cast(FloatValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.intValue(), x, false);
    }

    public static LongValue cast(FloatValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.longValue(), x, false);
    }

    public static BigInteger cast(FloatValue x, BigInteger y) {
        return BigInteger.valueOf(x.longValue());
    }

    public static BigDecimal cast(FloatValue x, BigDecimal y) {
        return BigDecimal.valueOf(x.doubleValue());
    }

    public static FloatValue round(FloatValue value) {
        if (value == null) {
            return null;
        }
        float rounded = Round.round((float)value.value, (int)0);
        FloatValue newValue = new FloatValue(rounded);
        return new FloatValue(newValue, NumberOperations.ROUND, value);
    }

    public static FloatValue round(FloatValue value, int scale) {
        if (value == null) {
            return null;
        }
        float rounded = Round.round((float)value.value, (int)scale);
        FloatValue newValue = new FloatValue(rounded);
        return new FloatValue(newValue, NumberOperations.ROUND, value, new FloatValue(scale));
    }

    public static FloatValue round(FloatValue value, int scale, int roundingMethod) {
        if (value == null) {
            return null;
        }
        float rounded = Round.round((Float)Float.valueOf(value.value), (int)scale, (int)roundingMethod).floatValue();
        FloatValue newValue = new FloatValue(rounded);
        return new FloatValue(newValue, NumberOperations.ROUND, value, new FloatValue(scale));
    }

    public FloatValue(String valueString) {
        this.value = Float.parseFloat(valueString);
    }

    public FloatValue(FloatValue result, NumberOperations function, FloatValue ... params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int compareTo(FloatValue o) {
        return Float.compare(this.value, o.value);
    }

    public int hashCode() {
        return Float.valueOf(this.value).hashCode();
    }

    private static Float[] unwrap(FloatValue[] values) {
        values = (FloatValue[])ArrayTool.removeNulls((Object[])values);
        Float[] unwrappedArray = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            unwrappedArray[i] = Float.valueOf(values[i].getValue());
        }
        return unwrappedArray;
    }

    public static class FloatValueAdapter
    extends XmlAdapter<Float, FloatValue> {
        public FloatValue unmarshal(Float val) throws Exception {
            return new FloatValue(val.floatValue());
        }

        public Float marshal(FloatValue val) throws Exception {
            return Float.valueOf(val.getValue());
        }
    }
}

