/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.exception.OpenLRuntimeException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=LongValueAdapter.class)
public class LongValue
extends ExplanationNumberValue<LongValue> {
    private static final long serialVersionUID = -437788531108803012L;
    public static final LongValue ZERO = new LongValue(0L);
    public static final LongValue ONE = new LongValue(1L);
    public static final LongValue MINUS_ONE = new LongValue(-1L);
    private final long value;

    private static DoubleValue[] toDoubleValues(LongValue[] values) {
        if (values == null) {
            return null;
        }
        DoubleValue[] doubleValues = new DoubleValue[values.length];
        int i = 0;
        for (LongValue value : values) {
            doubleValues[i] = LongValue.autocast(value, DoubleValue.ZERO);
            ++i;
        }
        return doubleValues;
    }

    public static DoubleValue avg(LongValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Number[] unwrappedArray = LongValue.unwrap(values);
        Double avg = MathUtils.avg((Number[])unwrappedArray);
        return new DoubleValue(new DoubleValue(avg), NumberOperations.AVG, LongValue.toDoubleValues(values));
    }

    public static LongValue sum(LongValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Long[] unwrappedArray = LongValue.unwrap(values);
        Long sum = MathUtils.sum((Long[])unwrappedArray);
        return new LongValue(new LongValue(sum), NumberOperations.SUM, values);
    }

    public static DoubleValue median(LongValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Number[] unwrappedArray = LongValue.unwrap(values);
        Double median = MathUtils.median((Number[])unwrappedArray);
        return new DoubleValue(new DoubleValue(median), NumberOperations.MEDIAN, LongValue.toDoubleValues(values));
    }

    public static LongValue max(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(MathUtils.max((long)value1.getValue(), (long)value2.getValue()) ? value1 : value2, NumberOperations.MAX, new LongValue[]{value1, value2});
    }

    public static LongValue min(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(MathUtils.min((long)value1.getValue(), (long)value2.getValue()) ? value1 : value2, NumberOperations.MIN, new LongValue[]{value1, value2});
    }

    public static LongValue max(LongValue[] values) {
        LongValue result = (LongValue)MathUtils.max((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new LongValue((LongValue)LongValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static LongValue min(LongValue[] values) {
        LongValue result = (LongValue)MathUtils.min((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new LongValue((LongValue)LongValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static LongValue copy(LongValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            LongValue result = new LongValue(value, NumberOperations.COPY, new LongValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static LongValue rem(LongValue value1, LongValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new LongValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static String add(LongValue value1, String value2) {
        return value1 + value2;
    }

    public static String add(String value1, LongValue value2) {
        return value1 + value2;
    }

    public static LongValue add(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static LongValue multiply(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static LongValue subtract(LongValue value1, LongValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return LongValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static DoubleValue divide(LongValue value1, LongValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new DoubleValue(null, new DoubleValue(value2.doubleValue()), LongValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new DoubleValue(new DoubleValue(value1.doubleValue()), null, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenLRuntimeException("Division by zero");
        }
        return new DoubleValue(new DoubleValue(value1.doubleValue()), new DoubleValue(value2.doubleValue()), Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(LongValue number, LongValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((long)number.getValue(), (long)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static DoubleValue product(LongValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Long[] unwrappedArray = LongValue.unwrap(values);
        double product = MathUtils.product((Long[])unwrappedArray).longValue();
        return new DoubleValue(new DoubleValue(product), NumberOperations.PRODUCT, null);
    }

    public static LongValue mod(LongValue number, LongValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.mod((long)number.getValue(), (long)divisor.getValue()));
            return new LongValue(result, NumberOperations.MOD, new LongValue[]{number, divisor});
        }
        return null;
    }

    public static LongValue small(LongValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = LongValue.unwrap(values);
        Long small = (Long)MathUtils.small((Comparable[])unwrappedArray, (int)position);
        return new LongValue((LongValue)LongValue.getAppropriateValue(values, new LongValue(small)), NumberOperations.SMALL, values);
    }

    public static LongValue big(LongValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = LongValue.unwrap(values);
        Long big = (Long)MathUtils.big((Comparable[])unwrappedArray, (int)position);
        return new LongValue((LongValue)LongValue.getAppropriateValue(values, new LongValue(big)), NumberOperations.BIG, values);
    }

    public static LongValue pow(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new LongValue(0L);
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(new LongValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new LongValue[]{value1, value2});
    }

    public static LongValue abs(LongValue value) {
        if (value == null) {
            return null;
        }
        LongValue result = new LongValue(Operators.abs(value.getValue()));
        return new LongValue(result, NumberOperations.ABS, new LongValue[]{value});
    }

    public static LongValue negative(LongValue value) {
        if (value == null) {
            return null;
        }
        return LongValue.multiply(value, MINUS_ONE);
    }

    public static LongValue inc(LongValue value) {
        return LongValue.add(value, ONE);
    }

    public static LongValue positive(LongValue value) {
        return value;
    }

    public static LongValue dec(LongValue value) {
        return LongValue.subtract(value, ONE);
    }

    public static LongValue autocast(byte x, LongValue y) {
        return new LongValue(x);
    }

    public static LongValue autocast(short x, LongValue y) {
        return new LongValue(x);
    }

    public static LongValue autocast(int x, LongValue y) {
        return new LongValue(x);
    }

    public static LongValue autocast(long x, LongValue y) {
        return new LongValue(x);
    }

    public static LongValue autocast(char x, LongValue y) {
        return new LongValue(x);
    }

    public LongValue(long value) {
        this.value = value;
    }

    public LongValue(LongValue lv1, LongValue lv2, long value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public LongValue(long value, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("LongValue", autocast));
        this.value = value;
    }

    @Override
    public LongValue copy(String name) {
        return LongValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof LongValue && this.value == ((LongValue)obj).value;
    }

    public static LongValue[] sort(LongValue[] values) {
        LongValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new LongValue[values.length];
            Object[] notNullArray = (LongValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            System.arraycopy(notNullArray, 0, sortedArray, 0, notNullArray.length);
        }
        return sortedArray;
    }

    public static FloatValue autocast(LongValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.getValue(), x, true);
    }

    public static DoubleValue autocast(LongValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.getValue(), x, true);
    }

    public static BigIntegerValue autocast(LongValue x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(String.valueOf(x.getValue()), x, true);
    }

    public static BigDecimalValue autocast(LongValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(String.valueOf(x.getValue()), x, true);
    }

    public static LongValue cast(float x, LongValue y) {
        return new LongValue((long)x);
    }

    public static LongValue cast(double x, LongValue y) {
        return new LongValue((long)x);
    }

    public static LongValue cast(BigInteger x, LongValue y) {
        return new LongValue(x.longValue());
    }

    public static LongValue cast(BigDecimal x, LongValue y) {
        return new LongValue(x.longValue());
    }

    public static byte cast(LongValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(LongValue x, short y) {
        return x.shortValue();
    }

    public static char cast(LongValue x, char y) {
        return (char)x.longValue();
    }

    public static int cast(LongValue x, int y) {
        return x.intValue();
    }

    public static long cast(LongValue x, long y) {
        return x.longValue();
    }

    public static float cast(LongValue x, float y) {
        return x.floatValue();
    }

    public static double cast(LongValue x, double y) {
        return x.doubleValue();
    }

    public static ByteValue cast(LongValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(LongValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public static IntValue cast(LongValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.intValue(), x, false);
    }

    public static BigInteger cast(LongValue x, BigInteger y) {
        return BigInteger.valueOf(x.longValue());
    }

    public static BigDecimal cast(LongValue x, BigDecimal y) {
        return BigDecimal.valueOf(x.longValue());
    }

    public LongValue(String valueString) {
        this.value = Long.parseLong(valueString);
    }

    public LongValue(LongValue result, NumberOperations function, LongValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.longValue();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int compareTo(LongValue o) {
        return Long.compare(this.value, o.value);
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    private static Long[] unwrap(LongValue[] values) {
        values = (LongValue[])ArrayTool.removeNulls((Object[])values);
        Long[] longArray = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            longArray[i] = values[i].getValue();
        }
        return longArray;
    }

    public static class LongValueAdapter
    extends XmlAdapter<Long, LongValue> {
        public LongValue unmarshal(Long val) throws Exception {
            return new LongValue(val);
        }

        public Long marshal(LongValue val) throws Exception {
            return val.getValue();
        }
    }
}

