/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.util.Arrays;
import java.util.Date;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.util.ArrayTool;

public class ObjectValue
implements IMetaHolder,
Comparable<ObjectValue> {
    private IMetaInfo metaInfo;
    private Object value;

    public ObjectValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Error initializing ObjectValue class. Parameter \"value\" can't be null.");
        }
        this.value = value;
        this.metaInfo = new ValueMetaInfo();
    }

    public ObjectValue(Object value, String shortName, String fullName, IOpenSourceCodeModule source) {
        if (value == null) {
            throw new IllegalArgumentException("Error initializing ObjectValue class. Parameter \"value\" can't be null.");
        }
        this.value = value;
        this.metaInfo = new ValueMetaInfo(shortName, fullName, source);
    }

    @Override
    public IMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public void setMetaInfo(IMetaInfo info) {
        this.metaInfo = info;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectValue) {
            ObjectValue v = (ObjectValue)obj;
            return this.value.equals(v.value);
        }
        return obj != null && this.value.equals(obj);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(ObjectValue objectToCompare) {
        int result = -1;
        if (this.value instanceof String && objectToCompare.getValue() instanceof String) {
            result = ((String)this.value).compareTo((String)objectToCompare.getValue());
        } else if (this.value instanceof Date && objectToCompare.getValue() instanceof Date) {
            result = ((Date)this.value).compareTo((Date)objectToCompare.getValue());
        } else if (this.value instanceof Boolean && objectToCompare.getValue() instanceof Boolean) {
            result = ((Boolean)this.value).compareTo((Boolean)objectToCompare.getValue());
        } else if (this.value instanceof Integer && objectToCompare.getValue() instanceof Integer) {
            result = ((Integer)this.value).compareTo((Integer)objectToCompare.getValue());
        }
        return result;
    }

    public static ObjectValue[] sort(ObjectValue[] values) {
        ObjectValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new ObjectValue[values.length];
            Object[] notNullArray = (ObjectValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            System.arraycopy(notNullArray, 0, sortedArray, 0, notNullArray.length);
        }
        return sortedArray;
    }
}

