/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.exception.OpenLRuntimeException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=ShortValueAdapter.class)
public class ShortValue
extends ExplanationNumberValue<ShortValue> {
    private static final long serialVersionUID = 5259931539737847856L;
    public static final ShortValue ZERO = new ShortValue(0);
    public static final ShortValue ONE = new ShortValue(1);
    public static final ShortValue MINUS_ONE = new ShortValue(-1);
    private final short value;

    private static DoubleValue[] toDoubleValues(ShortValue[] values) {
        if (values == null) {
            return null;
        }
        DoubleValue[] doubleValues = new DoubleValue[values.length];
        int i = 0;
        for (ShortValue value : values) {
            doubleValues[i] = ShortValue.autocast(value, DoubleValue.ZERO);
            ++i;
        }
        return doubleValues;
    }

    public static DoubleValue avg(ShortValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Number[] unwrappedArray = ShortValue.unwrap(values);
        Double avg = MathUtils.avg((Number[])unwrappedArray);
        return new DoubleValue(new DoubleValue(avg), NumberOperations.AVG, ShortValue.toDoubleValues(values));
    }

    public static ShortValue sum(ShortValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Short[] unwrappedArray = ShortValue.unwrap(values);
        Short sum = MathUtils.sum((Short[])unwrappedArray);
        return new ShortValue(new ShortValue(sum), NumberOperations.SUM, values);
    }

    public static DoubleValue median(ShortValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Number[] unwrappedArray = ShortValue.unwrap(values);
        Double median = MathUtils.median((Number[])unwrappedArray);
        return new DoubleValue(new DoubleValue(median), NumberOperations.MEDIAN, ShortValue.toDoubleValues(values));
    }

    public static ShortValue max(ShortValue value1, ShortValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new ShortValue(MathUtils.max((short)value1.getValue(), (short)value2.getValue()) ? value1 : value2, NumberOperations.MAX, new ShortValue[]{value1, value2});
    }

    public static ShortValue min(ShortValue value1, ShortValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new ShortValue(MathUtils.min((short)value1.getValue(), (short)value2.getValue()) ? value1 : value2, NumberOperations.MIN, new ShortValue[]{value1, value2});
    }

    public static ShortValue max(ShortValue[] values) {
        ShortValue result = (ShortValue)MathUtils.max((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new ShortValue((ShortValue)ShortValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static ShortValue min(ShortValue[] values) {
        ShortValue result = (ShortValue)MathUtils.min((Comparable[])values);
        if (result == null) {
            return null;
        }
        return new ShortValue((ShortValue)ShortValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static ShortValue copy(ShortValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            ShortValue result = new ShortValue(value, NumberOperations.COPY, new ShortValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static ShortValue rem(ShortValue value1, ShortValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new ShortValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static String add(ShortValue value1, String value2) {
        return value1 + value2;
    }

    public static String add(String value1, ShortValue value2) {
        return value1 + value2;
    }

    public static ShortValue add(ShortValue value1, ShortValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new ShortValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static ShortValue multiply(ShortValue value1, ShortValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new ShortValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static ShortValue subtract(ShortValue value1, ShortValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return ShortValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new ShortValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static DoubleValue divide(ShortValue value1, ShortValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new DoubleValue(null, new DoubleValue(value2.doubleValue()), ShortValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new DoubleValue(new DoubleValue(value1.doubleValue()), null, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenLRuntimeException("Division by zero");
        }
        return new DoubleValue(new DoubleValue(value1.doubleValue()), new DoubleValue(value2.doubleValue()), Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(ShortValue number, ShortValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((short)number.getValue(), (short)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static DoubleValue product(ShortValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Short[] unwrappedArray = ShortValue.unwrap(values);
        double product = MathUtils.product((Short[])unwrappedArray).longValue();
        return new DoubleValue(new DoubleValue(product), NumberOperations.PRODUCT, null);
    }

    public static ShortValue mod(ShortValue number, ShortValue divisor) {
        if (number != null && divisor != null) {
            ShortValue result = new ShortValue(MathUtils.mod((short)number.getValue(), (short)divisor.getValue()));
            return new ShortValue(result, NumberOperations.MOD, new ShortValue[]{number, divisor});
        }
        return null;
    }

    public static ShortValue small(ShortValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = ShortValue.unwrap(values);
        Short small = (Short)MathUtils.small((Comparable[])unwrappedArray, (int)position);
        return new ShortValue((ShortValue)ShortValue.getAppropriateValue(values, new ShortValue(small)), NumberOperations.SMALL, values);
    }

    public static ShortValue big(ShortValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        Comparable[] unwrappedArray = ShortValue.unwrap(values);
        Short big = (Short)MathUtils.big((Comparable[])unwrappedArray, (int)position);
        return new ShortValue((ShortValue)ShortValue.getAppropriateValue(values, new ShortValue(big)), NumberOperations.BIG, values);
    }

    public static ShortValue pow(ShortValue value1, ShortValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new ShortValue(0);
        }
        if (value2 == null) {
            return value1;
        }
        return new ShortValue(new ShortValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new ShortValue[]{value1, value2});
    }

    public static ShortValue abs(ShortValue value) {
        if (value == null) {
            return null;
        }
        ShortValue result = new ShortValue(Operators.abs(value.getValue()));
        return new ShortValue(result, NumberOperations.ABS, new ShortValue[]{value});
    }

    public static ShortValue negative(ShortValue value) {
        if (value == null) {
            return null;
        }
        return ShortValue.multiply(value, MINUS_ONE);
    }

    public static ShortValue inc(ShortValue value) {
        return ShortValue.add(value, ONE);
    }

    public static ShortValue positive(ShortValue value) {
        return value;
    }

    public static ShortValue dec(ShortValue value) {
        return ShortValue.subtract(value, ONE);
    }

    public static ShortValue autocast(byte x, ShortValue y) {
        return new ShortValue(x);
    }

    public static ShortValue autocast(short x, ShortValue y) {
        return new ShortValue(x);
    }

    public ShortValue(short value) {
        this.value = value;
    }

    public ShortValue(ShortValue lv1, ShortValue lv2, short value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public ShortValue(short value, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("ShortValue", autocast));
        this.value = value;
    }

    @Override
    public ShortValue copy(String name) {
        return ShortValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public short getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof ShortValue && this.value == ((ShortValue)obj).value;
    }

    public static ShortValue[] sort(ShortValue[] values) {
        ShortValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new ShortValue[values.length];
            Object[] notNullArray = (ShortValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            System.arraycopy(notNullArray, 0, sortedArray, 0, notNullArray.length);
        }
        return sortedArray;
    }

    public static IntValue autocast(ShortValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.getValue(), x, true);
    }

    public static LongValue autocast(ShortValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.getValue(), x, true);
    }

    public static FloatValue autocast(ShortValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.getValue(), x, true);
    }

    public static DoubleValue autocast(ShortValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.getValue(), x, true);
    }

    public static BigIntegerValue autocast(ShortValue x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(String.valueOf(x.getValue()), x, true);
    }

    public static BigDecimalValue autocast(ShortValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(String.valueOf(x.getValue()), x, true);
    }

    public static ShortValue cast(char x, ShortValue y) {
        return new ShortValue((short)x);
    }

    public static ShortValue cast(int x, ShortValue y) {
        return new ShortValue((short)x);
    }

    public static ShortValue cast(long x, ShortValue y) {
        return new ShortValue((short)x);
    }

    public static ShortValue cast(float x, ShortValue y) {
        return new ShortValue((short)x);
    }

    public static ShortValue cast(double x, ShortValue y) {
        return new ShortValue((short)x);
    }

    public static ShortValue cast(BigInteger x, ShortValue y) {
        return new ShortValue(x.shortValue());
    }

    public static ShortValue cast(BigDecimal x, ShortValue y) {
        return new ShortValue(x.shortValue());
    }

    public static byte cast(ShortValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(ShortValue x, short y) {
        return x.shortValue();
    }

    public static char cast(ShortValue x, char y) {
        return (char)x.shortValue();
    }

    public static int cast(ShortValue x, int y) {
        return x.intValue();
    }

    public static long cast(ShortValue x, long y) {
        return x.longValue();
    }

    public static float cast(ShortValue x, float y) {
        return x.floatValue();
    }

    public static double cast(ShortValue x, double y) {
        return x.doubleValue();
    }

    public static ByteValue cast(ShortValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static BigInteger cast(ShortValue x, BigInteger y) {
        return BigInteger.valueOf(x.shortValue());
    }

    public static BigDecimal cast(ShortValue x, BigDecimal y) {
        return BigDecimal.valueOf(x.shortValue());
    }

    public ShortValue(String valueString) {
        this.value = Short.parseShort(valueString);
    }

    public ShortValue(ShortValue result, NumberOperations function, ShortValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.shortValue();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int compareTo(ShortValue o) {
        return this.value - o.value;
    }

    public int hashCode() {
        return Short.valueOf(this.value).hashCode();
    }

    private static Short[] unwrap(ShortValue[] values) {
        values = (ShortValue[])ArrayTool.removeNulls((Object[])values);
        Short[] shortArray = new Short[values.length];
        for (int i = 0; i < values.length; ++i) {
            shortArray[i] = values[i].getValue();
        }
        return shortArray;
    }

    public static class ShortValueAdapter
    extends XmlAdapter<Short, ShortValue> {
        public ShortValue unmarshal(Short val) throws Exception {
            return new ShortValue(val);
        }

        public Short marshal(ShortValue val) throws Exception {
            return val.getValue();
        }
    }
}

