/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.net.URL;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.util.ArrayTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlJavaTypeAdapter(value=StringValueAdapter.class)
public class StringValue
implements IMetaHolder,
CharSequence,
Comparable<StringValue> {
    private final Logger log = LoggerFactory.getLogger(StringValue.class);
    private ValueMetaInfo metaInfo;
    private final String value;

    public StringValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Error initializing StringValue class. Parameter \"value\" can't be null.");
        }
        this.value = value;
        this.metaInfo = new ValueMetaInfo();
    }

    public StringValue(String value, String shortName, String fullName, IOpenSourceCodeModule source) {
        if (value == null) {
            throw new IllegalArgumentException("Error initializing StringValue class. Parameter \"value\" can't be null.");
        }
        this.value = value;
        this.metaInfo = new ValueMetaInfo(shortName, fullName, source);
    }

    public IOpenSourceCodeModule asSourceCodeModule() {
        return new StringSourceCodeModule(this.value, this.getMetaInfo().getSourceUrl());
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public int compareTo(StringValue v) {
        return this.value.compareTo(v.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringValue) {
            StringValue v = (StringValue)obj;
            return this.value.equals(v.value);
        }
        if (obj instanceof String) {
            String s = (String)obj;
            return this.value.equals(s);
        }
        return false;
    }

    @Override
    public ValueMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.value.trim().length() == 0;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public void setMetaInfo(IMetaInfo metaInfo) {
        if (metaInfo instanceof ValueMetaInfo) {
            this.setMetaInfo((ValueMetaInfo)metaInfo);
        } else {
            try {
                ValueMetaInfo valueMetaInfo = new ValueMetaInfo(metaInfo.getDisplayName(0), metaInfo.getDisplayName(2), new URLSourceCodeModule(new URL(metaInfo.getSourceUrl())));
                this.setMetaInfo(valueMetaInfo);
            }
            catch (Exception e) {
                this.log.debug("Failed to set meta info for StringValue \"{}\"", (Object)this.value, (Object)e);
                this.setMetaInfo((ValueMetaInfo)null);
            }
        }
    }

    public void setMetaInfo(ValueMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.value;
    }

    public static StringValue[] sort(StringValue[] values) {
        StringValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new StringValue[values.length];
            Object[] notNullArray = (StringValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            System.arraycopy(notNullArray, 0, sortedArray, 0, notNullArray.length);
        }
        return sortedArray;
    }

    public static StringValue autocast(String x, StringValue y) {
        return new StringValue(x);
    }

    public static String autocast(StringValue x, String y) {
        return x.getValue();
    }

    public static class StringValueAdapter
    extends XmlAdapter<String, StringValue> {
        public StringValue unmarshal(String val) throws Exception {
            return new StringValue(val);
        }

        public String marshal(StringValue val) throws Exception {
            return val.getValue();
        }
    }
}

