/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.openl.CompiledOpenClass;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.runtime.IRuntimeEnvBuilder;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.java.OpenClassHelper;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;

public abstract class AEngineFactory {
    private static final String FIELD_PREFIX = "get";

    @Deprecated
    public final Object makeInstance() {
        return this.newInstance();
    }

    public final Object newInstance() {
        return this.newInstance(this.getRuntimeEnvBuilder().buildRuntimeEnv());
    }

    protected final Object prepareProxyInstance(Object openClassInstance, Map<Method, IOpenMember> methodMap, IRuntimeEnv runtimeEnv, ClassLoader classLoader) {
        Class<?>[] proxyInterfaces = this.prepareInstanceInterfaces();
        InvocationHandler handler = this.prepareInvocationHandler(openClassInstance, methodMap, runtimeEnv);
        return Proxy.newProxyInstance(classLoader, proxyInterfaces, handler);
    }

    public final Object newInstance(IRuntimeEnv runtimeEnv) {
        if (runtimeEnv == null) {
            return this.prepareInstance(this.getRuntimeEnvBuilder().buildRuntimeEnv());
        }
        return this.prepareInstance(runtimeEnv);
    }

    protected abstract Object prepareInstance(IRuntimeEnv var1);

    protected abstract Class<?>[] prepareInstanceInterfaces();

    protected abstract IRuntimeEnvBuilder getRuntimeEnvBuilder();

    protected abstract InvocationHandler prepareInvocationHandler(Object var1, Map<Method, IOpenMember> var2, IRuntimeEnv var3);

    public abstract CompiledOpenClass getCompiledOpenClass();

    protected Map<Method, IOpenMember> prepareMethodMap(Class<?> engineInterface, IOpenClass moduleOpenClass) {
        Method[] interfaceMethods;
        HashMap<Method, IOpenMember> methodMap = new HashMap<Method, IOpenMember>();
        for (Method interfaceMethod : interfaceMethods = engineInterface.getDeclaredMethods()) {
            IOpenClass[] params;
            String interfaceMethodName = interfaceMethod.getName();
            IOpenMethod rulesMethod = moduleOpenClass.getMethod(interfaceMethodName, params = OpenClassHelper.getOpenClasses(moduleOpenClass, interfaceMethod.getParameterTypes()));
            if (rulesMethod != null) {
                methodMap.put(interfaceMethod, rulesMethod);
                continue;
            }
            if (interfaceMethodName.startsWith(FIELD_PREFIX)) {
                String fieldName = StringUtils.uncapitalize((String)interfaceMethodName.substring(FIELD_PREFIX.length()));
                IOpenField rulesField = moduleOpenClass.getField(fieldName, true);
                if (rulesField == null) {
                    fieldName = StringUtils.capitalize((String)fieldName);
                    rulesField = moduleOpenClass.getField(fieldName, true);
                }
                if (rulesField != null) {
                    IOpenClass methodReturnType = OpenClassHelper.getOpenClass(moduleOpenClass, interfaceMethod.getReturnType());
                    if (methodReturnType.getInstanceClass().isAssignableFrom(rulesField.getType().getInstanceClass())) {
                        methodMap.put(interfaceMethod, rulesField);
                        continue;
                    }
                    String message = String.format("Return type of method \"%s\" should be %s", interfaceMethodName, rulesField.getType());
                    throw new RuntimeException(message);
                }
            }
            String message = String.format("There is no implementation in rules for interface method \"%s\"", interfaceMethod);
            throw new OpenlNotCheckedException(message);
        }
        return methodMap;
    }
}

