/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.openl.OpenL;
import org.openl.conf.IUserContext;
import org.openl.conf.UserContext;
import org.openl.runtime.AEngineFactory;
import org.openl.runtime.IEngineWrapper;
import org.openl.runtime.IRuntimeEnvBuilder;
import org.openl.runtime.OpenLInvocationHandler;
import org.openl.types.IOpenMember;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;

public abstract class AOpenLEngineFactory
extends AEngineFactory {
    public static final String DEFAULT_USER_HOME = ".";
    private volatile OpenL openl;
    private volatile IUserContext userContext;
    private String openlName;
    private String userHome;
    protected IRuntimeEnvBuilder runtimeEnvBuilder;

    public AOpenLEngineFactory(String openlName) {
        this(openlName, DEFAULT_USER_HOME, null);
    }

    public AOpenLEngineFactory(String openlName, String userHome) {
        this(openlName, userHome, null);
    }

    public AOpenLEngineFactory(String openlName, IUserContext userContext) {
        this(openlName, DEFAULT_USER_HOME, userContext);
    }

    private AOpenLEngineFactory(String openlName, String userHome, IUserContext userContext) {
        this.openlName = openlName;
        this.userHome = userHome;
        this.userContext = userContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenL getOpenL() {
        if (this.openl == null) {
            AOpenLEngineFactory aOpenLEngineFactory = this;
            synchronized (aOpenLEngineFactory) {
                if (this.openl == null) {
                    this.openl = OpenL.getInstance(this.openlName, this.getUserContext());
                }
            }
        }
        return this.openl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUserContext getUserContext() {
        if (this.userContext == null) {
            AOpenLEngineFactory aOpenLEngineFactory = this;
            synchronized (aOpenLEngineFactory) {
                if (this.userContext == null) {
                    this.userContext = new UserContext(this.getDefaultUserClassLoader(), this.userHome);
                }
            }
        }
        return this.userContext;
    }

    private ClassLoader getDefaultUserClassLoader() {
        ClassLoader userClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            userClassLoader.loadClass(this.getClass().getName());
        }
        catch (ClassNotFoundException cnfe) {
            userClassLoader = this.getClass().getClassLoader();
        }
        return userClassLoader;
    }

    @Override
    protected IRuntimeEnvBuilder getRuntimeEnvBuilder() {
        if (this.runtimeEnvBuilder == null) {
            this.runtimeEnvBuilder = new IRuntimeEnvBuilder(){

                @Override
                public IRuntimeEnv buildRuntimeEnv() {
                    return new SimpleVM().getRuntimeEnv();
                }
            };
        }
        return this.runtimeEnvBuilder;
    }

    @Override
    protected Class<?>[] prepareInstanceInterfaces() {
        return new Class[]{IEngineWrapper.class};
    }

    @Override
    protected InvocationHandler prepareInvocationHandler(Object openClassInstance, Map<Method, IOpenMember> methodMap, IRuntimeEnv runtimeEnv) {
        return new OpenLInvocationHandler(openClassInstance, runtimeEnv, methodMap);
    }

    public String getOpenlName() {
        return this.openlName;
    }

    public String getUserHome() {
        return this.userHome;
    }
}

