/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.net.URL;
import org.openl.CompiledOpenClass;
import org.openl.classloader.OpenLBundleClassLoader;
import org.openl.classloader.SimpleBundleClassLoader;
import org.openl.conf.IUserContext;
import org.openl.dependency.IDependencyManager;
import org.openl.engine.OpenLManager;
import org.openl.runtime.AOpenLEngineFactory;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;

public abstract class ASourceCodeEngineFactory
extends AOpenLEngineFactory {
    private IOpenSourceCodeModule sourceCode;
    private boolean executionMode;
    private IDependencyManager dependencyManager;

    public ASourceCodeEngineFactory(String openlName, IOpenSourceCodeModule sourceCode, IUserContext userContext) {
        super(openlName, userContext);
        this.initSource(sourceCode);
    }

    public ASourceCodeEngineFactory(String openlName, IOpenSourceCodeModule sourceCode, String userHome) {
        super(openlName, userHome);
        this.initSource(sourceCode);
    }

    public ASourceCodeEngineFactory(String openlName, IOpenSourceCodeModule sourceCode) {
        super(openlName);
        this.initSource(sourceCode);
    }

    public ASourceCodeEngineFactory(String openlName, String sourceFile) {
        this(openlName, new URLSourceCodeModule(sourceFile));
    }

    public ASourceCodeEngineFactory(String openlName, String sourceFile, String userHome) {
        this(openlName, (IOpenSourceCodeModule)new URLSourceCodeModule(sourceFile), userHome);
    }

    public ASourceCodeEngineFactory(String openlName, URL source) {
        this(openlName, new URLSourceCodeModule(source));
    }

    private void initSource(IOpenSourceCodeModule sourceCode) {
        this.sourceCode = sourceCode;
    }

    public boolean isExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(boolean executionMode) {
        this.executionMode = executionMode;
    }

    public IOpenSourceCodeModule getSourceCode() {
        return this.sourceCode;
    }

    public IDependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public void setDependencyManager(IDependencyManager dependencyManager) {
        this.dependencyManager = dependencyManager;
    }

    protected CompiledOpenClass initializeOpenClass() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (!(oldClassLoader instanceof OpenLBundleClassLoader)) {
                SimpleBundleClassLoader newClassLoader = new SimpleBundleClassLoader(oldClassLoader);
                Thread.currentThread().setContextClassLoader(newClassLoader);
            }
            CompiledOpenClass compiledOpenClass = OpenLManager.compileModuleWithErrors(this.getOpenL(), this.getSourceCode(), this.executionMode, this.dependencyManager);
            return compiledOpenClass;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

