/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import org.openl.CompiledOpenClass;
import org.openl.conf.IUserContext;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.message.OpenLMessages;
import org.openl.runtime.ASourceCodeEngineFactory;
import org.openl.runtime.IEngineWrapper;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.vm.IRuntimeEnv;

public class EngineFactory<T>
extends ASourceCodeEngineFactory {
    private Class<T> interfaceClass;
    private CompiledOpenClass compiledOpenClass;
    protected Map<Method, IOpenMember> methodMap;

    protected EngineFactory(String openlName, IOpenSourceCodeModule sourceCode, IUserContext userContext) {
        super(openlName, sourceCode, userContext);
    }

    protected EngineFactory(String openlName, IOpenSourceCodeModule sourceCode, String userHome) {
        super(openlName, sourceCode, userHome);
    }

    protected EngineFactory(String openlName, IOpenSourceCodeModule sourceCode) {
        super(openlName, sourceCode);
    }

    protected EngineFactory(String openlName, String sourceFile, String userHome) {
        super(openlName, sourceFile, userHome);
    }

    protected EngineFactory(String openlName, String sourceFile) {
        super(openlName, sourceFile);
    }

    protected EngineFactory(String openlName, URL source) {
        super(openlName, source);
    }

    public EngineFactory(String openlName, IOpenSourceCodeModule sourceCode, IUserContext userContext, Class<T> interfaceClass) {
        super(openlName, sourceCode, userContext);
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Interface can't be null!");
        }
        this.interfaceClass = interfaceClass;
    }

    public EngineFactory(String openlName, IOpenSourceCodeModule sourceCode, String userHome, Class<T> interfaceClass) {
        super(openlName, sourceCode, userHome);
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Interface can't be null!");
        }
        this.interfaceClass = interfaceClass;
    }

    public EngineFactory(String openlName, IOpenSourceCodeModule sourceCode, Class<T> interfaceClass) {
        super(openlName, sourceCode);
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Interface can't be null!");
        }
        this.interfaceClass = interfaceClass;
    }

    public EngineFactory(String openlName, String sourceFile, String userHome, Class<T> interfaceClass) {
        super(openlName, sourceFile, userHome);
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Interface can't be null!");
        }
        this.interfaceClass = interfaceClass;
    }

    public EngineFactory(String openlName, String sourceFile, Class<T> interfaceClass) {
        super(openlName, sourceFile);
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Interface can't be null!");
        }
        this.interfaceClass = interfaceClass;
    }

    public EngineFactory(String openlName, URL source, Class<T> interfaceClass) {
        super(openlName, source);
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Interface can't be null!");
        }
        this.interfaceClass = interfaceClass;
    }

    public Class<T> getInterfaceClass() {
        return this.interfaceClass;
    }

    protected void setInterfaceClass(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public T newEngineInstance() {
        return (T)this.newInstance();
    }

    public T newEngineInstance(IRuntimeEnv runtimeEnv) {
        return (T)this.newInstance(runtimeEnv);
    }

    public void reset() {
        this.compiledOpenClass = null;
    }

    @Override
    protected Class<?>[] prepareInstanceInterfaces() {
        return new Class[]{this.getInterfaceClass(), IEngineWrapper.class};
    }

    @Override
    public Object prepareInstance(IRuntimeEnv runtimeEnv) {
        try {
            this.compiledOpenClass = this.getCompiledOpenClass();
            IOpenClass openClass = this.compiledOpenClass.getOpenClass();
            Map<Method, IOpenMember> methodMap = this.prepareMethodMap(this.getInterfaceClass(), openClass);
            Object openClassInstance = openClass.newInstance(runtimeEnv);
            return this.prepareProxyInstance(openClassInstance, methodMap, runtimeEnv, this.getInterfaceClass().getClassLoader());
        }
        catch (OpenlNotCheckedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OpenlNotCheckedException("Failed to instantiate engine instance!", ex);
        }
    }

    @Override
    public CompiledOpenClass getCompiledOpenClass() {
        if (this.compiledOpenClass == null) {
            OpenLMessages.getCurrentInstance().clear();
            this.compiledOpenClass = this.initializeOpenClass();
        }
        return this.compiledOpenClass;
    }
}

