/*
 * Decompiled with CFR 0.152.
 */
package org.openl.source.impl;

import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.util.fast.FastStringReader;

public class SubTextSourceCodeModule
implements IOpenSourceCodeModule {
    private IOpenSourceCodeModule baseModule;
    private int startPosition;
    private int endPosition = 0;
    private Map<String, Object> params;

    public SubTextSourceCodeModule(IOpenSourceCodeModule baseModule, int startPosition) {
        this.baseModule = baseModule;
        this.startPosition = startPosition;
    }

    public SubTextSourceCodeModule(IOpenSourceCodeModule baseModule, int startPosition, int endPosition) {
        this.baseModule = baseModule;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    @Override
    public InputStream getByteStream() {
        return null;
    }

    @Override
    public Reader getCharacterStream() {
        return new FastStringReader(this.getCode());
    }

    @Override
    public String getCode() {
        String code = this.baseModule.getCode();
        int end = this.endPosition <= 0 ? code.length() + this.endPosition : this.endPosition;
        return code.substring(this.startPosition, end);
    }

    @Override
    public int getStartPosition() {
        return this.startPosition;
    }

    public IOpenSourceCodeModule getBaseModule() {
        return this.baseModule;
    }

    @Override
    public String getUri() {
        return this.baseModule.getUri();
    }

    @Override
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public boolean isModified() {
        return this.baseModule.isModified();
    }
}

