/*
 * Decompiled with CFR 0.152.
 */
package org.openl.source.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openl.source.impl.ASourceCodeModule;
import org.openl.util.RuntimeExceptionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLSourceCodeModule
extends ASourceCodeModule {
    private final Logger log = LoggerFactory.getLogger(URLSourceCodeModule.class);
    private URL url;
    private long lastModified;

    public URLSourceCodeModule(URL url) {
        this.url = url;
        this.lastModified = this.getLastModified();
    }

    public URLSourceCodeModule(String file) {
        this(URLSourceCodeModule.toUrl(new File(file)));
    }

    public static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() {
        InputStream is = null;
        try {
            URLConnection conn = this.url.openConnection();
            long lastModified = conn.getLastModified();
            is = conn.getInputStream();
            long l = lastModified;
            return l;
        }
        catch (IOException e) {
            this.log.warn("Failed to open connection for URL \"{}\"", (Object)this.url, (Object)e);
            long l = -1L;
            return l;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public InputStream getByteStream() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    @Override
    public Reader getCharacterStream() {
        return new InputStreamReader(this.getByteStream());
    }

    @Override
    protected String makeUri() {
        return this.url.toExternalForm().replace(" ", "%20");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URLSourceCodeModule)) {
            return false;
        }
        URLSourceCodeModule urlSource = (URLSourceCodeModule)obj;
        return new EqualsBuilder().append((Object)this.url, (Object)urlSource.url).isEquals();
    }

    public int hashCode() {
        int hashCode = new HashCodeBuilder().append((Object)this.url).toHashCode();
        return hashCode;
    }

    public String toString() {
        return this.url.toString();
    }

    @Override
    public boolean isModified() {
        return this.getLastModified() != this.lastModified;
    }

    @Override
    public void resetModified() {
        this.lastModified = this.getLastModified();
    }
}

