/*
 * Decompiled with CFR 0.152.
 */
package org.openl.syntax.impl;

import org.openl.IOpenParser;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.impl.ParsedCode;
import org.openl.syntax.grammar.IGrammar;
import org.openl.syntax.grammar.IGrammarFactory;

public abstract class AParser
implements IOpenParser {
    private static final String INTEGER_RANGE_PARSING_TYPE = "range.literal";
    private static final String FLOAT_RANGE_PARSING_TYPE = "range.literal.real";

    protected abstract IGrammarFactory getGrammarFactory();

    @Override
    public IParsedCode parseAsMethodBody(IOpenSourceCodeModule source) {
        IGrammar grammar = this.getGrammarFactory().getGrammar();
        grammar.setModule(source);
        grammar.parseAsMethod(source.getCharacterStream());
        return this.makeParsedCode(grammar, source);
    }

    @Override
    public IParsedCode parseAsMethodHeader(IOpenSourceCodeModule source) {
        IGrammar grammar = this.getGrammarFactory().getGrammar();
        grammar.setModule(source);
        grammar.parseAsMethodHeader(source.getCharacterStream());
        return this.makeParsedCode(grammar, source);
    }

    @Override
    public IParsedCode parseAsModule(IOpenSourceCodeModule source) {
        IGrammar grammar = this.getGrammarFactory().getGrammar();
        grammar.setModule(source);
        grammar.parseAsModule(source.getCharacterStream());
        return this.makeParsedCode(grammar, source);
    }

    @Override
    public IParsedCode parseAsType(IOpenSourceCodeModule source) {
        IGrammar grammar = this.getGrammarFactory().getGrammar();
        grammar.setModule(source);
        grammar.parseAsType(source.getCharacterStream());
        return this.makeParsedCode(grammar, source);
    }

    @Override
    public IParsedCode parseAsFloatRange(IOpenSourceCodeModule source) {
        IGrammar grammar = this.getGrammarFactory().getGrammar();
        grammar.setModule(source);
        grammar.parse(source.getCharacterStream(), FLOAT_RANGE_PARSING_TYPE);
        return this.makeParsedCode(grammar, source);
    }

    @Override
    public IParsedCode parseAsIntegerRange(IOpenSourceCodeModule source) {
        IGrammar grammar = this.getGrammarFactory().getGrammar();
        grammar.setModule(source);
        grammar.parse(source.getCharacterStream(), INTEGER_RANGE_PARSING_TYPE);
        return this.makeParsedCode(grammar, source);
    }

    private ParsedCode makeParsedCode(IGrammar grammar, IOpenSourceCodeModule source) {
        ISyntaxNode node = grammar.getTopNode();
        return new ParsedCode(node, source, grammar.getErrors());
    }
}

