/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types;

import java.lang.reflect.Array;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaArrayAggregateInfo;
import org.openl.types.java.JavaOpenClass;

public class DomainOpenClassAggregateInfo
extends JavaArrayAggregateInfo {
    public static final IAggregateInfo DOMAIN_AGGREGATE = new DomainOpenClassAggregateInfo();

    @Override
    public IOpenClass getIndexedAggregateType(IOpenClass componentType, int dim) {
        DomainOpenClass domainType = (DomainOpenClass)componentType;
        int[] dims = new int[dim];
        Class<?> type = domainType.getInstanceClass();
        Class<?> clazz = Array.newInstance(type, dims).getClass();
        JavaOpenClass openClass = JavaOpenClass.getOpenClass(clazz);
        String domainName = domainType.getName();
        StringBuilder buf = new StringBuilder();
        buf.append(domainName);
        for (int i = 0; i < dim; ++i) {
            buf.append("[]");
        }
        String name = buf.toString();
        return new DomainOpenClass(name, openClass, domainType.getDomain(), domainType.getMetaInfo());
    }

    @Override
    public IOpenClass getComponentType(IOpenClass aggregateType) {
        DomainOpenClass domainType = (DomainOpenClass)aggregateType;
        String domainName = domainType.getName();
        String componentType = domainName.replaceFirst("\\[]", "");
        return new DomainOpenClass(componentType, super.getComponentType(domainType.getBaseClass()), domainType.getDomain(), domainType.getMetaInfo());
    }
}

