/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AOpenClass;
import org.openl.types.impl.DynamicObject;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaNoAggregateInfo;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.types.java.JavaOpenMethod;
import org.openl.vm.IRuntimeEnv;

public abstract class ADynamicClass
extends AOpenClass {
    private static final int MAX_DIM = 5;
    private String name = "<anonymous class>";
    protected Map<String, IOpenField> fieldMap;
    private Class<?> instanceClass;
    private IOpenClass[] arrayTypes = new IOpenClass[5];

    public ADynamicClass(String name, Class<?> instanceClass) {
        this.name = name;
        this.instanceClass = instanceClass;
        this.fieldMap = this.fieldMap();
    }

    public void addField(IOpenField field) {
        Map<String, IOpenField> fields = this.fieldMap();
        if (fields.containsKey(field.getName())) {
            IOpenField existedField = fields.get(field.getName());
            if (existedField != field) {
                throw new DuplicatedVarException("", field.getName());
            }
            return;
        }
        this.fieldMap().put(field.getName(), field);
        this.addFieldToLowerCaseMap(field);
    }

    @Override
    protected Map<MethodKey, IOpenMethod> initMethodMap() {
        Map<MethodKey, IOpenMethod> methodMap = super.initMethodMap();
        if (methodMap == STUB) {
            methodMap = new HashMap<MethodKey, IOpenMethod>(4);
        }
        if (this.instanceClass != null && !DynamicObject.class.isAssignableFrom(this.instanceClass)) {
            Method[] mm = this.instanceClass.getDeclaredMethods();
            if (this.isPublic(this.instanceClass)) {
                for (int i = 0; i < mm.length; ++i) {
                    if (!this.isPublic(mm[i])) continue;
                    JavaOpenMethod om = new JavaOpenMethod(mm[i]);
                    MethodKey kom = new MethodKey(om);
                    methodMap.put(kom, om);
                }
            }
        }
        return methodMap;
    }

    @Override
    protected Map<MethodKey, IOpenMethod> initConstructorMap() {
        Map<MethodKey, IOpenMethod> constructorMap = super.initConstructorMap();
        if (constructorMap == STUB) {
            constructorMap = new HashMap<MethodKey, IOpenMethod>(1);
        }
        OpenConstructor openConstructor = new OpenConstructor(this);
        MethodKey key = new MethodKey(openConstructor);
        constructorMap.put(key, openConstructor);
        Constructor<?>[] cc = this.instanceClass.getDeclaredConstructors();
        for (int i = 0; i < cc.length; ++i) {
            if (!this.isPublic(cc[i])) continue;
            JavaOpenConstructor om = new JavaOpenConstructor(cc[i]);
            MethodKey kom = new MethodKey(om);
            constructorMap.put(kom, om);
        }
        return constructorMap;
    }

    @Override
    public void addMethod(IOpenMethod method) {
        super.addMethod(method);
    }

    @Override
    protected Map<String, IOpenField> fieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap<String, IOpenField>();
        }
        return this.fieldMap;
    }

    @Override
    public IAggregateInfo getAggregateInfo() {
        return JavaNoAggregateInfo.NO_AGGREGATE;
    }

    public String getDisplayName(int mode) {
        return this.name;
    }

    @Override
    public Class<?> getInstanceClass() {
        return this.instanceClass;
    }

    protected boolean isPublic(Class<?> declaringClass) {
        return Modifier.isPublic(declaringClass.getModifiers());
    }

    protected boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public void setInstanceClass(Class<?> instanceClass) {
        this.instanceClass = instanceClass;
        this.invalidateInternalData();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getJavaName() {
        return this.instanceClass.getName();
    }

    @Override
    public boolean isAssignableFrom(Class<?> c) {
        return this.instanceClass.isAssignableFrom(c);
    }

    @Override
    public boolean isAssignableFrom(IOpenClass ioc) {
        return this.instanceClass.isAssignableFrom(ioc.getInstanceClass());
    }

    @Override
    public boolean isInstance(Object instance) {
        return this.instanceClass.isInstance(instance);
    }

    @Override
    public Iterable<IOpenClass> superClasses() {
        return Collections.emptyList();
    }

    protected IOpenClass[] getArrayTypes() {
        return this.arrayTypes;
    }

    public static class OpenConstructor
    implements IOpenMethod {
        IOpenClass openClass;

        OpenConstructor(IOpenClass openClass) {
            this.openClass = openClass;
        }

        @Override
        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public String getDisplayName(int mode) {
            return this.openClass.getDisplayName(mode);
        }

        @Override
        public IMemberMetaInfo getInfo() {
            return null;
        }

        @Override
        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return this.openClass.getName();
        }

        @Override
        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        @Override
        public IOpenClass getType() {
            return this.openClass;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            return this.openClass.newInstance(env);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        public String toString() {
            return this.openClass.getName();
        }

        @Override
        public boolean isConstructor() {
            return true;
        }
    }
}

