/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openl.binding.exception.AmbiguousVarException;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.domain.IDomain;
import org.openl.domain.IType;
import org.openl.meta.IMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenClass;

public abstract class AOpenClass
implements IOpenClass {
    protected static final Map<MethodKey, IOpenMethod> STUB = Collections.unmodifiableMap(Collections.emptyMap());
    private IOpenField indexField;
    protected IMetaInfo metaInfo;
    protected Map<String, IOpenField> uniqueLowerCaseFieldMap = null;
    protected Map<String, List<IOpenField>> nonUniqueLowerCaseFieldMap = null;
    private volatile Map<MethodKey, IOpenMethod> methodMap;
    private volatile Map<MethodKey, IOpenMethod> constructorMap;
    private Collection<IOpenMethod> allMethodsCache = null;
    private volatile boolean allMethodsCacheInvalidated = true;
    private Map<String, List<IOpenMethod>> allMethodNamesMap = null;
    private volatile boolean allMethodNamesMapInvalidated = true;
    private Map<String, List<IOpenMethod>> allConstructorNamesMap = null;
    private volatile boolean allConstructorNamesMapInvalidated = true;

    protected synchronized void addFieldToLowerCaseMap(IOpenField f) {
        if (this.uniqueLowerCaseFieldMap == null) {
            return;
        }
        String lname = f.getName().toLowerCase().replace(" ", "");
        if (this.uniqueLowerCaseFieldMap.containsKey(lname)) {
            this.initNonUniqueMap();
            ArrayList<IOpenField> ff = new ArrayList<IOpenField>(2);
            ff.add(this.uniqueLowerCaseFieldMap.get(lname));
            ff.add(f);
            this.nonUniqueLowerCaseFieldMap.put(lname, ff);
            this.uniqueLowerCaseFieldMap.remove(lname);
        } else if (this.nonUniqueLowerCaseFieldMap != null && this.nonUniqueLowerCaseFieldMap.containsKey(lname)) {
            this.nonUniqueLowerCaseFieldMap.get(lname).add(f);
        } else {
            this.uniqueLowerCaseFieldMap.put(lname, f);
        }
    }

    protected abstract Map<String, IOpenField> fieldMap();

    @Override
    public Map<String, IOpenField> getFields() {
        HashMap<String, IOpenField> fields = new HashMap<String, IOpenField>();
        Iterable<IOpenClass> superClasses = this.superClasses();
        for (IOpenClass superClass : superClasses) {
            fields.putAll(superClass.getFields());
        }
        fields.putAll(this.fieldMap());
        return fields;
    }

    @Override
    public Map<String, IOpenField> getDeclaredFields() {
        return new HashMap<String, IOpenField>(this.fieldMap());
    }

    public static IOpenClass getArrayType(IOpenClass openClass, int dim) {
        if (dim > 0) {
            JavaOpenClass arrayType = JavaOpenClass.getOpenClass(Array.newInstance(openClass.getInstanceClass(), dim).getClass());
            if (openClass.getDomain() != null) {
                StringBuilder domainOpenClassName = new StringBuilder(openClass.getName());
                for (int j = 0; j < dim; ++j) {
                    domainOpenClassName.append("[]");
                }
                DomainOpenClass domainArrayType = new DomainOpenClass(domainOpenClassName.toString(), arrayType, openClass.getDomain(), null);
                return domainArrayType;
            }
            return arrayType;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IOpenClass getArrayType(int dim) {
        return AOpenClass.getArrayType(this, dim);
    }

    public IDomain<?> getDomain() {
        return null;
    }

    @Override
    public IOpenField getField(String fname) {
        return this.getField(fname, true);
    }

    @Override
    public IOpenField getField(String fname, boolean strictMatch) {
        IOpenField f = null;
        if (strictMatch) {
            Map<String, IOpenField> m = this.fieldMap();
            IOpenField iOpenField = f = m == null ? null : m.get(fname);
            if (f != null) {
                return f;
            }
            return this.searchFieldFromSuperClass(fname, strictMatch);
        }
        String lfname = fname.toLowerCase();
        Map<String, IOpenField> uniqueLowerCaseFields = this.getUniqueLowerCaseFieldMap();
        if (uniqueLowerCaseFields != null && (f = uniqueLowerCaseFields.get(lfname)) != null) {
            return f;
        }
        Map<String, List<IOpenField>> nonUniqueLowerCaseFields = this.getNonUniqueLowerCaseFieldMap();
        List<IOpenField> ff = nonUniqueLowerCaseFields.get(lfname);
        if (ff != null) {
            throw new AmbiguousVarException(fname, ff);
        }
        return this.searchFieldFromSuperClass(fname, strictMatch);
    }

    private IOpenField searchFieldFromSuperClass(String fname, boolean strictMatch) {
        Iterable<IOpenClass> superClasses = this.superClasses();
        for (IOpenClass superClass : superClasses) {
            IOpenField f = superClass.getField(fname, strictMatch);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    @Override
    public IOpenField getIndexField() {
        return this.indexField;
    }

    @Override
    public IOpenMethod getConstructor(String name, IOpenClass[] params) {
        Map<MethodKey, IOpenMethod> m = this.constructorMap();
        MethodKey methodKey = new MethodKey(name, params, true);
        return m.get(methodKey);
    }

    @Override
    public IMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public IOpenMethod getMethod(String name, IOpenClass[] classes) {
        IOpenMethod method = this.getDeclaredMethod(name, classes);
        if (method == null) {
            Iterator<IOpenClass> superClasses = this.superClasses().iterator();
            while (method == null && superClasses.hasNext()) {
                method = superClasses.next().getMethod(name, classes);
            }
        }
        return method;
    }

    public String getNameSpace() {
        return "org.openl.this";
    }

    private synchronized Map<String, List<IOpenField>> getNonUniqueLowerCaseFieldMap() {
        if (this.nonUniqueLowerCaseFieldMap == null) {
            this.makeLowerCaseMaps();
        }
        return this.nonUniqueLowerCaseFieldMap;
    }

    @Override
    public IOpenClass getOpenClass() {
        return this;
    }

    private synchronized Map<String, IOpenField> getUniqueLowerCaseFieldMap() {
        if (this.uniqueLowerCaseFieldMap == null) {
            this.makeLowerCaseMaps();
        }
        return this.uniqueLowerCaseFieldMap;
    }

    @Override
    public IOpenField getVar(String name, boolean strictMatch) {
        return this.getField(name, strictMatch);
    }

    private void initNonUniqueMap() {
        if (this.nonUniqueLowerCaseFieldMap == null) {
            this.nonUniqueLowerCaseFieldMap = new HashMap<String, List<IOpenField>>();
        }
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    public boolean isAssignableFrom(IType type) {
        if (type instanceof IOpenClass) {
            return this.isAssignableFrom((IOpenClass)type);
        }
        return false;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isArray() {
        if (this.getInstanceClass() != null) {
            return this.getInstanceClass().isArray();
        }
        return false;
    }

    @Override
    public IOpenClass getComponentClass() {
        return null;
    }

    private void makeLowerCaseMaps() {
        this.uniqueLowerCaseFieldMap = new HashMap<String, IOpenField>();
        for (IOpenField field : this.getFields().values()) {
            this.addFieldToLowerCaseMap(field);
        }
        if (this.nonUniqueLowerCaseFieldMap == null) {
            this.nonUniqueLowerCaseFieldMap = Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MethodKey, IOpenMethod> methodMap() {
        if (this.methodMap == null) {
            AOpenClass aOpenClass = this;
            synchronized (aOpenClass) {
                if (this.methodMap == null) {
                    this.methodMap = this.initMethodMap();
                }
            }
        }
        return this.methodMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MethodKey, IOpenMethod> constructorMap() {
        if (this.constructorMap == null) {
            AOpenClass aOpenClass = this;
            synchronized (aOpenClass) {
                if (this.constructorMap == null) {
                    this.constructorMap = this.initConstructorMap();
                }
            }
        }
        return this.constructorMap;
    }

    protected Map<MethodKey, IOpenMethod> initMethodMap() {
        return STUB;
    }

    protected Map<MethodKey, IOpenMethod> initConstructorMap() {
        return STUB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOpenMethod putMethod(IOpenMethod method) {
        if (this.methodMap == null || this.methodMap == STUB) {
            AOpenClass aOpenClass = this;
            synchronized (aOpenClass) {
                if (this.methodMap == null) {
                    this.methodMap = this.initMethodMap();
                }
                if (this.methodMap == STUB) {
                    this.methodMap = new HashMap<MethodKey, IOpenMethod>(4);
                }
            }
        }
        MethodKey key = new MethodKey(method);
        IOpenMethod existMethod = this.methodMap.put(key, method);
        return existMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOpenMethod putConstructor(IOpenMethod method) {
        if (this.constructorMap == null || this.constructorMap == STUB) {
            AOpenClass aOpenClass = this;
            synchronized (aOpenClass) {
                if (this.constructorMap == null) {
                    this.constructorMap = this.initConstructorMap();
                }
                if (this.constructorMap == STUB) {
                    this.constructorMap = new HashMap<MethodKey, IOpenMethod>(4);
                }
            }
        }
        MethodKey key = new MethodKey(method);
        IOpenMethod existConstructor = this.constructorMap.put(key, method);
        return existConstructor;
    }

    protected void addMethod(IOpenMethod method) {
        MethodKey key = new MethodKey(method);
        IOpenMethod existMethod = this.putMethod(method);
        if (existMethod != null) {
            throw new DuplicatedMethodException("Method '" + key + "' have bean already defined for class '" + this.getName() + "'", method);
        }
        this.invalidateInternalData();
    }

    public void addConstructor(IOpenMethod method) {
        MethodKey key = new MethodKey(method);
        IOpenMethod existCostructor = this.putConstructor(method);
        if (existCostructor != null) {
            throw new DuplicatedMethodException("Constructor '" + key + "' have bean already defined for class '" + this.getName() + "'", method);
        }
    }

    protected void overrideMethod(IOpenMethod method) {
        MethodKey key = new MethodKey(method);
        IOpenMethod existMethod = this.putMethod(method);
        if (existMethod == null) {
            throw new IllegalStateException("Method '" + key + "' is absent to override in class '" + this.getName() + "'");
        }
        this.invalidateInternalData();
    }

    protected final void invalidateInternalData() {
        this.allMethodsCacheInvalidated = true;
        this.allMethodNamesMapInvalidated = true;
        this.allConstructorNamesMapInvalidated = true;
        this.constructorMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<IOpenMethod> getMethods() {
        if (this.allMethodsCacheInvalidated) {
            AOpenClass aOpenClass = this;
            synchronized (aOpenClass) {
                if (this.allMethodNamesMapInvalidated) {
                    this.allMethodsCache = this.buildAllMethods();
                    this.allMethodsCacheInvalidated = false;
                }
            }
        }
        return this.allMethodsCache;
    }

    public final Collection<IOpenMethod> getConstructors() {
        return Collections.unmodifiableCollection(this.constructorMap().values());
    }

    private Collection<IOpenMethod> buildAllMethods() {
        HashMap<MethodKey, IOpenMethod> methods = new HashMap<MethodKey, IOpenMethod>();
        Iterable<IOpenClass> superClasses = this.superClasses();
        for (IOpenClass superClass : superClasses) {
            for (IOpenMethod method : superClass.getMethods()) {
                methods.put(new MethodKey(method), method);
            }
        }
        Map<MethodKey, IOpenMethod> m = this.methodMap();
        if (m != null) {
            methods.putAll(m);
        }
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(methods.values());
    }

    public IOpenMethod getDeclaredMethod(String name, IOpenClass[] classes) {
        Map<MethodKey, IOpenMethod> m = this.methodMap();
        MethodKey methodKey = new MethodKey(name, classes);
        return m.get(methodKey);
    }

    @Override
    public Collection<IOpenMethod> getDeclaredMethods() {
        return this.methodMap().values();
    }

    @Override
    public Object nullObject() {
        return null;
    }

    public void setIndexField(IOpenField field) {
        this.indexField = field;
    }

    @Override
    public void setMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void addType(IOpenClass type) throws Exception {
    }

    @Override
    public IOpenClass findType(String name) {
        return null;
    }

    @Override
    public Collection<IOpenClass> getTypes() {
        return Collections.emptyList();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IOpenClass)) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getName(), (Object)((IOpenClass)obj).getName()).isEquals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterable<IOpenMethod> methods(String name) {
        List<IOpenMethod> found;
        if (this.allMethodNamesMapInvalidated) {
            AOpenClass aOpenClass = this;
            synchronized (aOpenClass) {
                if (this.allMethodNamesMapInvalidated) {
                    this.allMethodNamesMap = AOpenClass.buildMethodNameMap(this.getMethods());
                    this.allMethodNamesMapInvalidated = false;
                }
            }
        }
        return (found = this.allMethodNamesMap.get(name)) == null ? Collections.emptyList() : Collections.unmodifiableList(found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterable<IOpenMethod> constructors(String name) {
        List<IOpenMethod> found;
        if (this.allConstructorNamesMapInvalidated) {
            AOpenClass aOpenClass = this;
            synchronized (aOpenClass) {
                if (this.allConstructorNamesMapInvalidated) {
                    this.allConstructorNamesMap = AOpenClass.buildMethodNameMap(this.getConstructors());
                    this.allConstructorNamesMapInvalidated = false;
                }
            }
        }
        return (found = this.allConstructorNamesMap.get(name)) == null ? Collections.emptyList() : Collections.unmodifiableList(found);
    }

    public static Map<String, List<IOpenMethod>> buildMethodNameMap(Iterable<IOpenMethod> methods) {
        HashMap<String, List<IOpenMethod>> res = new HashMap<String, List<IOpenMethod>>();
        for (IOpenMethod m : methods) {
            String name = m.getName();
            LinkedList<IOpenMethod> list = (LinkedList<IOpenMethod>)res.get(name);
            if (list == null) {
                list = new LinkedList<IOpenMethod>();
                res.put(name, list);
            }
            list.add(m);
        }
        return res;
    }
}

