/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openl.message.OpenLMessagesUtils;
import org.openl.types.IOpenClass;
import org.openl.types.impl.AOpenField;
import org.openl.util.StringTool;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeOpenField
extends AOpenField {
    private final Logger log = LoggerFactory.getLogger(DatatypeOpenField.class);
    private IOpenClass declaringClass;
    private String getterMethodName;
    private String setterMethodName;

    public DatatypeOpenField(IOpenClass declaringClass, String name, IOpenClass type) {
        super(name, type);
        this.getterMethodName = StringTool.getGetterName((String)this.getName());
        this.setterMethodName = StringTool.getSetterName((String)this.getName());
        this.declaringClass = declaringClass;
    }

    public DatatypeOpenField(String name, IOpenClass type) {
        super(name, type);
    }

    @Override
    public Object get(Object target, IRuntimeEnv env) {
        if (target == null) {
            return null;
        }
        Object res = null;
        Class<?> targetClass = target.getClass();
        try {
            try {
                Method method = targetClass.getMethod(this.getterMethodName, new Class[0]);
                res = method.invoke(target, new Object[0]);
            }
            catch (NoSuchMethodException e1) {
                this.processError(e1);
            }
            catch (IllegalArgumentException e) {
                this.processError(e);
            }
            catch (IllegalAccessException e) {
                this.processError(e);
            }
            catch (InvocationTargetException e) {
                this.processError(e);
            }
        }
        catch (SecurityException e) {
            this.processError(e);
        }
        return res != null ? res : this.getType().nullObject();
    }

    @Override
    public IOpenClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void set(Object target, Object value, IRuntimeEnv env) {
        Class<?> targetClass = target.getClass();
        try {
            try {
                Method method = targetClass.getMethod(this.setterMethodName, this.getType().getInstanceClass());
                method.invoke(target, value);
            }
            catch (NoSuchMethodException e1) {
                String errorMessage = String.format("There is no setter method in class %s for the field %s with type %s", targetClass.getSimpleName(), this.getName(), this.getType().getInstanceClass().getSimpleName());
                this.processError(errorMessage, e1);
            }
            catch (IllegalArgumentException e1) {
                this.processError(e1);
            }
            catch (IllegalAccessException e1) {
                this.processError(e1);
            }
            catch (InvocationTargetException e1) {
                this.processError(e1);
            }
        }
        catch (SecurityException e1) {
            this.processError(e1);
        }
    }

    private void processError(Throwable e1) {
        this.log.error("{}", (Object)this, (Object)e1);
        OpenLMessagesUtils.addError(e1);
    }

    private void processError(String errorMessage, Throwable e1) {
        this.log.error(errorMessage + "\n{}", (Object)this, (Object)e1);
        OpenLMessagesUtils.addError(errorMessage);
    }

    public void setDeclaringClass(IOpenClass declaringClass) {
        this.declaringClass = declaringClass;
    }
}

