/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.domain.IDomain;
import org.openl.domain.IType;
import org.openl.meta.IMetaInfo;
import org.openl.types.DomainOpenClassAggregateInfo;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AOpenClass;
import org.openl.vm.IRuntimeEnv;

public class DomainOpenClass
implements IOpenClass {
    private IDomain<?> domain;
    private IAggregateInfo aggregateInfo;
    private IOpenClass baseClass;
    private String name;
    private IMetaInfo metaInfo;

    public DomainOpenClass(String name, IOpenClass baseClass, IDomain<?> domain, IMetaInfo metaInfo) {
        assert (name != null);
        this.baseClass = baseClass;
        this.name = name;
        this.metaInfo = metaInfo;
        this.domain = domain;
    }

    public IDomain<?> getDomain() {
        return this.domain;
    }

    public void setDomain(IDomain<?> domain) {
        this.domain = domain;
    }

    @Override
    public IAggregateInfo getAggregateInfo() {
        if (this.aggregateInfo == null) {
            this.aggregateInfo = DomainOpenClassAggregateInfo.DOMAIN_AGGREGATE;
        }
        return this.aggregateInfo;
    }

    public String getDisplayName(int mode) {
        return this.getName();
    }

    public IOpenClass getBaseClass() {
        return this.baseClass;
    }

    @Override
    public IOpenField getField(String fname) {
        return this.baseClass.getField(fname);
    }

    @Override
    public IOpenField getField(String fname, boolean strictMatch) {
        return this.baseClass.getField(fname, strictMatch);
    }

    @Override
    public IOpenField getIndexField() {
        return this.baseClass.getIndexField();
    }

    @Override
    public Class<?> getInstanceClass() {
        return this.baseClass.getInstanceClass();
    }

    @Override
    public IOpenMethod getConstructor(String name, IOpenClass[] params) throws AmbiguousMethodException {
        return this.baseClass.getConstructor(name, params);
    }

    @Override
    public IMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public IOpenMethod getMethod(String mname, IOpenClass[] classes) {
        return this.baseClass.getMethod(mname, classes);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getJavaName() {
        return this.baseClass.getJavaName();
    }

    public String getNameSpace() {
        return null;
    }

    @Override
    public IOpenClass getOpenClass() {
        return this;
    }

    @Override
    public IOpenField getVar(String vname, boolean strictMatch) {
        return this.baseClass.getVar(vname, strictMatch);
    }

    @Override
    public boolean isAbstract() {
        return this.baseClass.isAbstract();
    }

    @Override
    public boolean isAssignableFrom(Class<?> c) {
        return this.baseClass.isAssignableFrom(c);
    }

    @Override
    public boolean isAssignableFrom(IOpenClass ioc) {
        return this.baseClass.isAssignableFrom(ioc);
    }

    public boolean isAssignableFrom(IType type) {
        return this.baseClass.isAssignableFrom(type);
    }

    @Override
    public boolean isInstance(Object instance) {
        return this.baseClass.isInstance(instance);
    }

    @Override
    public boolean isSimple() {
        return this.baseClass.isSimple();
    }

    @Override
    public boolean isArray() {
        return this.baseClass.isArray();
    }

    @Override
    public IOpenClass getComponentClass() {
        return this.baseClass.getComponentClass();
    }

    @Override
    public Object newInstance(IRuntimeEnv env) {
        return this.baseClass.newInstance(env);
    }

    @Override
    public Object nullObject() {
        return this.baseClass.nullObject();
    }

    @Override
    public void setMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    @Override
    public Iterable<IOpenClass> superClasses() {
        return this.baseClass.superClasses();
    }

    public String toString() {
        return (this.getNameSpace() == null ? "" : this.getNameSpace() + ":") + this.getName();
    }

    @Override
    public void addType(IOpenClass type) throws Exception {
    }

    @Override
    public IOpenClass findType(String typeName) {
        return null;
    }

    @Override
    public Collection<IOpenClass> getTypes() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, IOpenField> getFields() {
        return this.baseClass.getFields();
    }

    @Override
    public Map<String, IOpenField> getDeclaredFields() {
        return this.baseClass.getDeclaredFields();
    }

    @Override
    public Collection<IOpenMethod> getMethods() {
        return this.baseClass.getMethods();
    }

    @Override
    public Collection<IOpenMethod> getDeclaredMethods() {
        return this.baseClass.getMethods();
    }

    @Override
    public Iterable<IOpenMethod> methods(String name) {
        return this.baseClass.methods(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainOpenClass that = (DomainOpenClass)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Iterable<IOpenMethod> constructors(String name) {
        return this.baseClass.constructors(name);
    }

    @Override
    public IOpenClass getArrayType(int dim) {
        return AOpenClass.getArrayType(this, dim);
    }
}

